/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.searchSimpleMatrix;

import com.gridnine.sabre.bfm.BookFlightSegmentType;
import com.gridnine.sabre.bfm.OriginDestinationOptionType;
import com.gridnine.sabre.bfm.PricedItineraryType;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.SimpleMatrixElement;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.OTAAirLowFareSearchRSParsingHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class OTAAirLowFareSearchSimpleMatrixParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ArrayList<SimpleMatrixElement> simpleMatrix = (ArrayList<SimpleMatrixElement>)ctx.getObject((Enum)IBusGdsContextKeys.SIMPLE_MATRIX);
        if (simpleMatrix == null) {
            simpleMatrix = new ArrayList<SimpleMatrixElement>();
            ctx.putObject((Enum)IBusGdsContextKeys.SIMPLE_MATRIX, simpleMatrix);
        }
        PricedItineraryType pricedItinerary = (PricedItineraryType)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PRICED_ITINERARY);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        SimpleMatrixElement element = this.buildSimpleMatrixElement(pricedItinerary, fsp.getRoute().size());
        simpleMatrix.add(element);
    }

    private SimpleMatrixElement buildSimpleMatrixElement(PricedItineraryType pricedItinerary, int routeSize) {
        List odoList = pricedItinerary.getAirItinerary().getOriginDestinationOptions().getOriginDestinationOptionList();
        SimpleMatrixElement element = new SimpleMatrixElement();
        element.setBestPrice(this.buildBestPrice(pricedItinerary));
        element.setDateFrom(this.buildDateFrom(odoList));
        element.setDateTo(this.buildDateTo(odoList, routeSize));
        return element;
    }

    private Money buildBestPrice(PricedItineraryType pricedItinerary) {
        PricedItineraryType.AirItineraryPricingInfo airItineraryPricingInfo = (PricedItineraryType.AirItineraryPricingInfo)pricedItinerary.getAirItineraryPricingInfoList().get(0);
        BigDecimal value = airItineraryPricingInfo.getPTCFareBreakdowns1().getPTCFareBreakdownList().stream().map(fareBreakDown -> fareBreakDown.getPassengerFare().getTotalFareCurrencyAmountType().getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        String currency = airItineraryPricingInfo.getPTCFareBreakdowns1().getPTCFareBreakdownList().stream().map(fareBreakDown -> fareBreakDown.getPassengerFare().getTotalFareCurrencyAmountType().getCurrencyCodeGroup().getCurrencyCode()).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"currency must not be null", (Object[])new Object[0]));
        return MoneyHelper.buildMoney((BigDecimal)value, (String)currency);
    }

    private LocalDate buildDateFrom(List<OriginDestinationOptionType> odoList) {
        String dateFrom = ((BookFlightSegmentType)odoList.get(0).getFlightSegmentList().get(0)).getDepartureDateTime();
        return OTAAirLowFareSearchRSParsingHelper.parseLocalDate(dateFrom);
    }

    private LocalDate buildDateTo(List<OriginDestinationOptionType> odoList, int routeSize) {
        if (routeSize == 2) {
            List lastSegmentList = odoList.get(odoList.size() - 1).getFlightSegmentList();
            String dateTo = ((BookFlightSegmentType)lastSegmentList.get(lastSegmentList.size() - 1)).getDepartureDateTime();
            return OTAAirLowFareSearchRSParsingHelper.parseLocalDate(dateTo);
        }
        return null;
    }
}

