/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.seatsMap;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FrequentTravellerAgreements;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.stl.merchandising.v6.CabinDefinition;
import com.sabre.stl.merchandising.v6.CustomerLoyalty;
import com.sabre.stl.merchandising.v6.EnhancedSeatMapRQ;
import com.sabre.stl.merchandising.v6.FareAvailQualifiers;
import com.sabre.stl.merchandising.v6.Flight;
import com.sabre.stl.merchandising.v6.FlightDate;
import com.sabre.stl.merchandising.v6.FlightIdentifier;
import com.sabre.stl.merchandising.v6.POS;
import com.sabre.stl.merchandising.v6.Request;
import com.sabre.stl.merchandising.v6.SeatMapQueryEnhanced;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SeatMapRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSegment segment = (FlightSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENT);
        com.gridnine.xtrip.common.gds.model.Flight flight = (com.gridnine.xtrip.common.gds.model.Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        List gdsTravellers = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        EnhancedSeatMapRQ request = new EnhancedSeatMapRQ();
        SeatMapQueryEnhanced query = new SeatMapQueryEnhanced();
        query.setRequestType(Request.PAYLOAD);
        query.setFlight(this.getQueryFlight(segment));
        query.setCabinDefinition(this.getCabinDefinition(segment.getBookingClass()));
        int infantsCount = this.getInfantPassengersCount(gdsTravellers);
        boolean hasInfantPassengerType = false;
        int travellerId = 0;
        for (Traveller traveller : travellers) {
            GdsTraveller gdsTraveller = gdsTravellers.stream().filter(gdsTrav -> gdsTrav.getTravellerUid().equals(traveller.getUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"GDS Traveller not found", (Object[])new Object[0]));
            if (DictHelper.isInfantPassengerType((DictionaryReference)gdsTraveller.getPassengerType())) continue;
            if (infantsCount > 0 && DictHelper.isAdultPassengerType((DictionaryReference)gdsTraveller.getPassengerType())) {
                --infantsCount;
                hasInfantPassengerType = true;
            }
            gdsTraveller.setGdsId(String.valueOf(++travellerId));
            query.getFareAvailQualifierList().add(this.getFareAvailQualifiers(flight, segment, traveller, gdsTraveller, hasInfantPassengerType));
        }
        POS pos = new POS();
        pos.setPCC(((SabreGdsAccount)accountCtr.getEntity()).getPrimaryPCC());
        query.setPOS(pos);
        request.setSeatMapQueryEnhanced(query);
        request.setVersion("6.0.0");
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"EnhancedSeatMapRQ");
    }

    private Flight getQueryFlight(FlightSegment segment) {
        Flight result = new Flight();
        result.setOrigin(SabreHelper.getNativeCode((DictionaryReference)segment.getLocationBegin()));
        result.setDestination(SabreHelper.getNativeCode((DictionaryReference)segment.getLocationEnd()));
        FlightDate fd = new FlightDate();
        fd.setDate(MiscUtil.toSqlDate((Date)segment.getDateBegin()));
        result.setDepartureDate(fd);
        FlightIdentifier fid = new FlightIdentifier();
        fid.setCarrier(SabreHelper.getNativeCode((DictionaryReference)segment.getAirline()));
        fid.setString(segment.getFlightNumber());
        result.getMarketingList().add(fid);
        return result;
    }

    private CabinDefinition getCabinDefinition(String bookingClass) {
        CabinDefinition result = new CabinDefinition();
        result.setRBD(bookingClass);
        return result;
    }

    private FareAvailQualifiers getFareAvailQualifiers(com.gridnine.xtrip.common.gds.model.Flight flight, FlightSegment segment, Traveller traveller, GdsTraveller gdsTraveller, boolean hasInfantPassengerType) {
        FareAvailQualifiers result = new FareAvailQualifiers();
        result.setTravellerID(gdsTraveller.getGdsId());
        String fareBasisCode = segment.getFareInfos().stream().filter(fi -> fi.getPassengerType().equals((Object)gdsTraveller.getPassengerType())).findFirst().map(FareInfo::getFareBasis).orElse(null);
        result.setFareBasisCode(fareBasisCode);
        result.setPassengerType(SabreHelper.getNativeCode((DictionaryReference)gdsTraveller.getPassengerType()));
        result.setGivenName(SabreHelper.buildGivenName((Passport)traveller.getPassport(), (DictionaryReference)gdsTraveller.getPassengerType(), (SabreHelper.SabreAviaParametersProvider)new SabreHelper.FlightParametersProvider(flight, traveller.getPassport())));
        result.setAccompaniedByInfantInd(Boolean.valueOf(hasInfantPassengerType));
        result.setSurname(SabreHelper.buildSurname((Passport)traveller.getPassport(), (boolean)true));
        if (!traveller.getAirlineBonusCards().isEmpty()) {
            for (AirlineBonusCard bonusCard : traveller.getAirlineBonusCards()) {
                CustomerLoyalty loyalty = this.getCustomerLoyalty(bonusCard, segment);
                if (loyalty == null) continue;
                result.getLoyaltyList().add(loyalty);
            }
        }
        return result;
    }

    private int getInfantPassengersCount(List<GdsTraveller> gdsTravellers) {
        return (int)gdsTravellers.stream().map(GdsTraveller::getPassengerType).filter(DictHelper::isInfantPassengerType).count();
    }

    private CustomerLoyalty getCustomerLoyalty(AirlineBonusCard bonusCard, FlightSegment segment) {
        DictionaryReference<Airline> partnerAirLine = null;
        if (segment.getAirline().equals((Object)bonusCard.getAirline()) && (partnerAirLine = this.getPartnerAirline(bonusCard, segment)) == null) {
            return null;
        }
        CustomerLoyalty loyalty = new CustomerLoyalty();
        loyalty.setString(bonusCard.getNumber());
        loyalty.setCarrier(SabreHelper.getNativeCode((DictionaryReference)bonusCard.getAirline()));
        loyalty.setPartnerProgram(SabreHelper.getNativeCode(partnerAirLine));
        return loyalty;
    }

    private DictionaryReference<Airline> getPartnerAirline(AirlineBonusCard bonusCard, FlightSegment segment) {
        DictionaryReference partnerAirLine = null;
        Collection<FrequentTravellerAgreements> partnerAgreements = SabreServerHelper.getFrequentTravellerAgreementsByOwningCarrier((DictionaryReference<Airline>)bonusCard.getAirline());
        for (FrequentTravellerAgreements agreements : partnerAgreements) {
            if (!segment.getAirline().equals((Object)agreements.getReceivingCarrier())) continue;
            partnerAirLine = agreements.getReceivingCarrier();
            break;
        }
        return partnerAirLine;
    }
}

