/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.seatsMap;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AircraftDeck;
import com.gridnine.xtrip.common.gds.model.AircraftDeckLocation;
import com.gridnine.xtrip.common.gds.model.AircraftSeat;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsMap;
import com.gridnine.xtrip.common.gds.model.AircraftSeatsRow;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.TravellerAircraftSeatsMap;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.stl.merchandising.v6.Cabin;
import com.sabre.stl.merchandising.v6.EnhancedSeatMapRS;
import com.sabre.stl.merchandising.v6.EnumColumnDescription;
import com.sabre.stl.merchandising.v6.EnumSeatLimitationsTypeBase;
import com.sabre.stl.merchandising.v6.EnumSeatLocationTypeBase;
import com.sabre.stl.merchandising.v6.EnumSeatOccupationTypeBase;
import com.sabre.stl.merchandising.v6.EnumSeatRowTypeBase;
import com.sabre.stl.merchandising.v6.FareAvailQualifiers;
import com.sabre.stl.merchandising.v6.Offer;
import com.sabre.stl.merchandising.v6.Row;
import com.sabre.stl.merchandising.v6.Seat;
import com.sabre.stl.merchandising.v6.SeatFacilities1;
import com.sabre.stl.merchandising.v6.SeatLimitations1;
import com.sabre.stl.merchandising.v6.SeatLocation1;
import com.sabre.stl.merchandising.v6.SeatMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SeatsMapResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EnhancedSeatMapRS response = (EnhancedSeatMapRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        if (response.getSeatMapList() != null && response.getSeatMapList().size() > 1) {
            this.log.error("SeatMapList has more than 1 element");
            return;
        }
        AircraftSeatsMap seatsMap = new AircraftSeatsMap();
        if (response.getSeatMapList() == null || response.getSeatMapList().isEmpty()) {
            ctx.putObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP, (Object)seatsMap);
            return;
        }
        SeatMap gdsSeatMap = (SeatMap)response.getSeatMapList().get(0);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        FlightSegment segment = (FlightSegment)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENT);
        List gdsTravellers = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        boolean paidSeatsAvailable = (Boolean)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.EMD_ACTIVE);
        HashMap<Traveller, GdsTraveller> travellerGdsTravellerMap = new HashMap<Traveller, GdsTraveller>();
        block0: for (Traveller traveller : travellers) {
            for (GdsTraveller gdsTraveller2 : gdsTravellers) {
                if (!gdsTraveller2.getTravellerUid().equals(traveller.getUid())) continue;
                travellerGdsTravellerMap.put(traveller, gdsTraveller2);
                continue block0;
            }
        }
        boolean hasInfantPassengerType = gdsTravellers.stream().anyMatch(gdsTraveller -> DictHelper.isInfantPassengerType((DictionaryReference)gdsTraveller.getPassengerType()));
        HashMap deckCabinsMap = new HashMap();
        gdsSeatMap.getCabinList().forEach(cabin -> {
            AircraftDeckLocation deckLocation = SabreServerHelper.classLocation2AircraftDeckLocation(cabin.getClassLocation());
            List cabs = deckCabinsMap.computeIfAbsent(deckLocation, k -> new ArrayList());
            cabs.add(cabin);
        });
        seatsMap.setSegmentId(segment.getGdsId());
        for (Traveller traveller : travellers) {
            if (DictHelper.isInfantPassengerType((DictionaryReference)((GdsTraveller)travellerGdsTravellerMap.get(traveller)).getPassengerType())) continue;
            GdsTraveller gdsTraveller3 = (GdsTraveller)travellerGdsTravellerMap.get(traveller);
            boolean travellerWithInfant = hasInfantPassengerType && this.isTravellerWithInfant(gdsTraveller3, gdsSeatMap);
            TravellerAircraftSeatsMap travellerSeatsMap = new TravellerAircraftSeatsMap();
            travellerSeatsMap.setTraveller(traveller);
            for (Map.Entry entry : deckCabinsMap.entrySet()) {
                AircraftDeckBuilder deckBuilder = new AircraftDeckBuilder(flight, gdsTraveller3, (AircraftDeckLocation)entry.getKey(), (List)entry.getValue(), paidSeatsAvailable, travellerWithInfant);
                travellerSeatsMap.getDecks().add(deckBuilder.build());
            }
            seatsMap.getSeatsMapsByTravellers().add(travellerSeatsMap);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.AIRCRAFT_SEATS_MAP, (Object)seatsMap);
    }

    private boolean isTravellerWithInfant(GdsTraveller gdsTraveller, SeatMap gdsSeatMap) {
        if (!DictHelper.isAdultPassengerType((DictionaryReference)gdsTraveller.getPassengerType())) {
            return false;
        }
        for (FareAvailQualifiers qualifiers : gdsSeatMap.getFareAvailQualifierList()) {
            if (!qualifiers.getAccompaniedByInfantInd().booleanValue() || !qualifiers.getTravellerID().equals(gdsTraveller.getGdsId())) continue;
            return true;
        }
        return false;
    }

    private static class AircraftDeckBuilder {
        private final Flight flight;
        private final AircraftDeckLocation deckLocation;
        private final GdsTraveller gdsTraveller;
        private final List<Cabin> cabins;
        private final boolean paidSeatsAvailable;
        private final boolean travellerWithInfant;

        public AircraftDeckBuilder(Flight flight, GdsTraveller gdsTraveller, AircraftDeckLocation deckLocation, List<Cabin> cabins, boolean paidSeatsAvailable, boolean travellerWithInfant) {
            this.flight = flight;
            this.deckLocation = deckLocation;
            this.gdsTraveller = gdsTraveller;
            this.cabins = cabins;
            this.paidSeatsAvailable = paidSeatsAvailable;
            this.travellerWithInfant = travellerWithInfant;
        }

        private AircraftDeck build() {
            AircraftDeck result = new AircraftDeck();
            result.setLocation(this.deckLocation);
            for (Cabin cabin : this.cabins) {
                for (Row row : cabin.getRowList()) {
                    if (row.getTypeList() != null && row.getTypeList().stream().anyMatch(enumSeatRowType -> enumSeatRowType.getEnumSeatRowTypeBase() == EnumSeatRowTypeBase.ROW_DOES_NOT_EXIST)) continue;
                    result.getSeatsRows().add(this.convertGdsSeatsRow2AircraftSeatsRow(cabin, row));
                }
            }
            return result;
        }

        private AircraftSeatsRow convertGdsSeatsRow2AircraftSeatsRow(Cabin cabin, Row gdsSeatsRow) {
            AircraftSeatsRow result = new AircraftSeatsRow();
            result.setNumber(Integer.parseInt(gdsSeatsRow.getRowNumber()));
            result.getSeats().addAll(gdsSeatsRow.getSeatList().stream().map(seat -> this.convertGdsSeat2AircraftSeat(cabin, (Seat)seat)).collect(Collectors.toList()));
            return result;
        }

        private AircraftSeat convertGdsSeat2AircraftSeat(Cabin cabin, Seat gdsSeat) {
            AircraftSeat result = new AircraftSeat();
            result.setNumber(gdsSeat.getNumber());
            if (this.isNoSeat(gdsSeat)) {
                result.setNoSeat(true);
            } else if (this.isOccupiedSeat(gdsSeat)) {
                result.setOccupied(true);
            }
            result.setGds(this.flight.getGds());
            boolean seatUnavailable = result.isNoSeat() || result.isOccupied();
            result.setEquivalentAmount(this.getSeatPrice(gdsSeat, seatUnavailable));
            HashSet gdsSeatCharacteristics = new HashSet();
            if (gdsSeat.getLocationList() != null) {
                gdsSeat.getLocationList().stream().map(SeatLocation1::getDetail).filter(Objects::nonNull).map(detail -> detail.getEnumSeatLocationTypeBase().xmlValue()).forEach(gdsSeatCharacteristics::add);
            }
            if (gdsSeat.getLimitationList() != null) {
                gdsSeat.getLimitationList().stream().map(SeatLimitations1::getDetail).filter(Objects::nonNull).map(detail -> detail.getEnumSeatLimitationsTypeBase().xmlValue()).forEach(gdsSeatCharacteristics::add);
            }
            if (gdsSeat.getFacilityList() != null) {
                gdsSeat.getFacilityList().stream().map(SeatFacilities1::getDetail).filter(Objects::nonNull).map(detail -> detail.getEnumSeatFacilitiesTypeBase().xmlValue()).forEach(gdsSeatCharacteristics::add);
            }
            if (cabin.getColumnList() != null) {
                cabin.getColumnList().stream().filter(column -> gdsSeat.getNumber().equals(column.getColumn())).filter(column -> column.getCharacteristicList() != null).flatMap(column -> column.getCharacteristicList().stream()).filter(Objects::nonNull).map(EnumColumnDescription::xmlValue).forEach(gdsSeatCharacteristics::add);
            }
            result.getCharacteristics().addAll(DictHelper.getSeatCharacteristicsWithUniqueTranslation(gdsSeatCharacteristics, (GdsName)GdsName.SABRE));
            for (String gdsCharacteristics : gdsSeatCharacteristics) {
                result.getIndicators().addAll(SabreHelper.gdsSeatCharacteristic2SeatIndicators((String)gdsCharacteristics));
            }
            return result;
        }

        private boolean isOccupiedSeat(Seat gdsSeat) {
            boolean occupied;
            boolean bl = occupied = BooleanUtil.nullAsFalse((Boolean)gdsSeat.getOccupiedInd()) || gdsSeat.getOccupationList() != null && gdsSeat.getOccupationList().stream().noneMatch(occupation -> occupation.getDetail().getEnumSeatOccupationTypeBase() == EnumSeatOccupationTypeBase.SEAT_IS_FREE) || gdsSeat.getLimitationList() != null && gdsSeat.getLimitationList().stream().anyMatch(limitation -> limitation.getDetail().getEnumSeatLimitationsTypeBase() == EnumSeatLimitationsTypeBase.SEAT_TO_BE_LEFT_VACANT_OFFERED_LAST);
            if (occupied) {
                return true;
            }
            Offer travellerOffer = this.findTravellerOffer(gdsSeat);
            if (!this.paidSeatsAvailable && this.isChargeableSeat(travellerOffer)) {
                return true;
            }
            if (this.travellerWithInfant && this.seatIsNotSuitableForInfants(gdsSeat) || DictHelper.isInfantPassengerType((DictionaryReference)this.gdsTraveller.getPassengerType())) {
                return true;
            }
            return DictHelper.isChildPassengerType((DictionaryReference)this.gdsTraveller.getPassengerType()) && this.seatIsNotSuitableForChildren(gdsSeat);
        }

        private Offer findTravellerOffer(Seat gdsSeat) {
            if (gdsSeat.getOfferList() == null || gdsSeat.getOfferList().isEmpty()) {
                return null;
            }
            return gdsSeat.getOfferList().stream().filter(offer -> offer.getTravellerID().equals(this.gdsTraveller.getGdsId())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)String.format("No offer found for travellerID=%s", this.gdsTraveller.getGdsId()), (Object[])new Object[0]));
        }

        private boolean isNoSeat(Seat gdsSeat) {
            if (gdsSeat.getOccupationList() != null && gdsSeat.getOccupationList().stream().anyMatch(occupation -> occupation.getDetail().getEnumSeatOccupationTypeBase() == EnumSeatOccupationTypeBase.NO_SEAT_HERE)) {
                return true;
            }
            return gdsSeat.getLocationList() != null && gdsSeat.getLocationList().stream().anyMatch(location -> location.getDetail().getEnumSeatLocationTypeBase() == EnumSeatLocationTypeBase.NO_SEAT_AT_THIS_LOCATION);
        }

        private boolean isChargeableSeat(Offer travellerOffer) {
            if (travellerOffer == null) {
                return false;
            }
            return travellerOffer.getCommercialName().equals("PRE RESERVED SEAT ASSIGNMENT");
        }

        private boolean seatIsNotSuitableForInfants(Seat gdsSeat) {
            return gdsSeat.getNoInfantInd() == Boolean.TRUE || gdsSeat.getLimitationList() != null && gdsSeat.getLimitationList().stream().anyMatch(limitation -> limitation.getDetail().getEnumSeatLimitationsTypeBase() == EnumSeatLimitationsTypeBase.SEAT_NOT_SUITABLE_FOR_CHILD);
        }

        private boolean seatIsNotSuitableForChildren(Seat gdsSeat) {
            return gdsSeat.getLimitationList() != null && gdsSeat.getLimitationList().stream().anyMatch(limitation -> limitation.getDetail().getEnumSeatLimitationsTypeBase() == EnumSeatLimitationsTypeBase.SEAT_NOT_SUITABLE_FOR_CHILD);
        }

        private BigDecimal getSeatPrice(Seat gdsSeat, boolean seatUnavailable) {
            if (seatUnavailable) {
                return null;
            }
            BigDecimal price = null;
            Offer travellerOffer = this.findTravellerOffer(gdsSeat);
            if (travellerOffer == null) {
                return null;
            }
            if (this.paidSeatsAvailable && this.isChargeableSeat(travellerOffer)) {
                if (travellerOffer.getPrice() != null) {
                    price = travellerOffer.getPrice().getTotalAmount().getDecimal();
                } else if (travellerOffer.getBasePrice() != null) {
                    price = travellerOffer.getBasePrice().getTotalAmount().getDecimal();
                }
            }
            return price;
        }
    }
}

