/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.seatsMap;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;

public class WAEPCommandResponseParser
extends BaseProcessor {
    private static final Pattern RESPONSE_ELEMENT_PATTERN = Pattern.compile(".*\\n");
    private static final Pattern PROFILE_DOES_NOT_EXIST_PATTERN = Pattern.compile("INVALID OPTION-PROFILE DOES NOT EXIST.*");

    public void process(MessageContext ctx) throws Exception {
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        if (PROFILE_DOES_NOT_EXIST_PATTERN.matcher(response).matches()) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.EMD_ACTIVE, (Object)Boolean.FALSE);
            return;
        }
        Matcher matcher = RESPONSE_ELEMENT_PATTERN.matcher(response);
        Boolean emdActive = null;
        block0: while (matcher.find()) {
            String elementContent = matcher.group();
            if (TextUtil.isBlank((String)elementContent) || !elementContent.contains("ELECTRONIC MISCELLANEOUS DOCUMENT")) continue;
            matcher.find();
            if (!matcher.find()) continue;
            elementContent = matcher.group();
            if (TextUtils.isBlank((CharSequence)elementContent) || !elementContent.contains("EMD-A")) {
                throw Xeption.forDeveloper((String)"unexpected WAEP command response structure: EMD-A not found", (Object[])new Object[0]);
            }
            String[] emds = elementContent.trim().split("\\s+");
            int indexOfEmdA = -1;
            for (int i = 0; i < emds.length; ++i) {
                if (!emds[i].equals("EMD-A")) continue;
                indexOfEmdA = i;
                break;
            }
            if (indexOfEmdA == -1) {
                throw Xeption.forDeveloper((String)"unexpected result: EMD-A not found", (Object[])new Object[0]);
            }
            while (matcher.find()) {
                elementContent = matcher.group();
                if (TextUtil.isBlank((String)elementContent) || !elementContent.contains("ACTIVE")) break block0;
                String[] statuses = elementContent.trim().split("\\s{2,}");
                String statusOfEmdA = statuses[0].contains("STATUS") ? statuses[indexOfEmdA + 1] : statuses[indexOfEmdA];
                if (!statusOfEmdA.startsWith("1S")) continue;
                emdActive = Boolean.valueOf(statusOfEmdA.contains("INACTIVE")) != false ? Boolean.FALSE : Boolean.TRUE;
            }
        }
        if (emdActive == null) {
            throw Xeption.forDeveloper((String)"emdActive is not defined", (Object[])new Object[0]);
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.EMD_ACTIVE, emdActive);
    }
}

