/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.selectFlight;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightOBFeeInfo;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.OBFeesInfo;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreRemarksSearchContext;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.KeyValuePair;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetailsSegmentInfo;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GetReservationFlightParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Date lastTicketingDate = (Date)ctx.getObject((Enum)IBusGdsSabreContextKeys.LAST_TICKETING_DATE);
        Map cabinInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_INFO);
        Map luggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.LUGGAGE_INFO);
        Map cabinLuggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_LUGGAGE_INFO);
        String calcLine = this.getCalcLine(ctx);
        Flight oldFlight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        List flightSegments = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEGMENTS);
        List ancillaryFees = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.SABRE_ANCILLARY_FEES);
        Flight flight = this.parseFlight(response, gdsParameters, (EntityContainer<SabreGdsAccount>)accountCtr, oldFlight, flightSegments, lastTicketingDate, calcLine, cabinInfo, luggageInfo, cabinLuggageInfo, ancillaryFees);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)flight);
    }

    /*
     * WARNING - void declaration
     */
    private Flight parseFlight(GetReservationRSType response, GDSParameters gdsParameters, EntityContainer<SabreGdsAccount> accountCtr, Flight oldFlight, List<FlightSegment> flightSegments, Date lastTicketingDate, String calcLine, Map<String, List<String>> cabinInfo, Map<String, Map<List<String>, ExtendedLuggageInfo>> luggageInfo, Map<String, Map<List<String>, ExtendedLuggageInfo>> cabinLuggageInfo, List<AncillaryFee> ancillaryFees) throws Exception {
        void var19_23;
        Flight flight = new Flight();
        flight.setSalesOriginContent(SalesOriginContent.SABRE);
        flight.setSalesOriginProvider(SalesOriginProvider.SABRE);
        if (oldFlight != null) {
            flight.setSeatsMapAvailable(oldFlight.isSeatsMapAvailable());
            flight.setAncillaryFeesRequestNeeded(oldFlight.isAncillaryFeesRequestNeeded());
            flight.getAncillaryFees().addAll(oldFlight.getAncillaryFees());
            flight.setAccountCode(oldFlight.getAccountCode());
            flight.setAccountCodeApplied(true);
            flight.setCorporateId(oldFlight.getCorporateId());
            flight.setCorporateIdApplied(true);
            if (!StringUtils.isBlank((String)flight.getAccountCode()) || !StringUtils.isBlank((String)flight.getCorporateId())) {
                if (flight.getTripartiteContractDetails() == null) {
                    flight.setTripartiteContractDetails(new TripartiteContractDetails());
                }
                flight.getTripartiteContractDetails().setIssuedUnder3d(true);
            }
            flight.setSabreSmartPricePricing(oldFlight.isSabreSmartPricePricing());
            flight.setSalesChain(oldFlight.getSalesChain());
        }
        flight.setBlankOwner(gdsParameters.getBlankOwner());
        flight.setBlockCharter(false);
        flight.setCarrier(SabreHelper.resolveNativeCode(Airline.class, (String)((String)GetReservationHelper.getValidPriceQuotes(response).get(0).getMiscellaneousInfo().getValidatingCarrierList().get(0))));
        flight.setEticket(true);
        flight.setGds(((SabreGdsAccount)accountCtr.getEntity()).getGds());
        flight.setGdsAccount(accountCtr.toReference());
        flight.setLatinRegistration(true);
        SabreCustomPropertiesHelper.setLastTicketingDate(flight, lastTicketingDate);
        ArrayList fareInfos = new ArrayList();
        boolean cabinsSet = false;
        Iterator<FlightSegment> fsIter = flightSegments.iterator();
        ArrayList<PriceQuoteDetailsSegmentInfo> pqSegments = null;
        HashMap<DictionaryReference, Map<String, String>> brandIds = new HashMap<DictionaryReference, Map<String, String>>();
        for (PriceQuoteDetails priceQuoteDetails : GetReservationHelper.getValidPriceQuotes(response)) {
            String passengerTypeCode = GetReservationHelper.deteminePassengerTypeCode(priceQuoteDetails);
            if (!cabinsSet) {
                cabinInfo.get(passengerTypeCode).forEach(cabin -> ((FlightSegment)fsIter.next()).setServiceClass(SabreHelper.cabin2ClassOfService((String)cabin)));
                cabinsSet = true;
            }
            Map<List<String>, ExtendedLuggageInfo> ptcLuggageInfo = luggageInfo.get(passengerTypeCode);
            Map<List<String>, ExtendedLuggageInfo> ptcCabinLuggageInfo = cabinLuggageInfo.get(passengerTypeCode);
            DictionaryReference passengerType = SabreHelper.resolveNativeCode(PassengerType.class, (String)passengerTypeCode);
            flight.getPrivateFare().put(passengerType, priceQuoteDetails.getFareInfo().getFareIndicators().getPrivateFareType() != null);
            brandIds.put(passengerType, GetReservationHelper.getBrandIds(priceQuoteDetails));
            SeatPreferences sp = new SeatPreferences();
            sp.setPassengerType(passengerType);
            sp.setCount(GetReservationFlightParser.getPassengerTypeQuantity(priceQuoteDetails));
            flight.getSeats().add(sp);
            if (flight.getGdsCurrencyCode() == null) {
                flight.setGdsCurrencyCode(priceQuoteDetails.getFareInfo().getTotalFare().getCurrencyCode());
            }
            FlightFare fare = new FlightFare();
            Money m = new Money();
            m.setCurrency(priceQuoteDetails.getFareInfo().getBaseFare().getCurrencyCode());
            m.setValue(new BigDecimal(priceQuoteDetails.getFareInfo().getBaseFare().getString()));
            fare.setBaseAmount(m);
            fare.setEquivalentAmount(GetReservationHelper.parseEquivalentFare(priceQuoteDetails));
            fare.setPassengerType(passengerType);
            flight.getFares().add(fare);
            for (GetReservationHelper.TaxAbstraction ta : GetReservationHelper.parseTaxes(priceQuoteDetails.getFareInfo().getTaxInfo())) {
                FlightTax ft = ta.toFlightTax();
                ft.setPassengerType(passengerType);
                flight.getTaxes().add(ft);
            }
            FlightOBFeeInfo obFeesInfo = new FlightOBFeeInfo();
            if (GetReservationHelper.parseObFeesInfo(priceQuoteDetails, (OBFeesInfo)obFeesInfo)) {
                obFeesInfo.setPassengerType(passengerType);
                flight.getObFeesInfos().add(obFeesInfo);
            }
            ArrayList<PriceQuoteDetailsSegmentInfo> localPqSegments = null;
            if (pqSegments == null) {
                localPqSegments = new ArrayList<PriceQuoteDetailsSegmentInfo>();
            }
            int i = 0;
            for (PriceQuoteDetailsSegmentInfo fs : priceQuoteDetails.getSegmentInfoList()) {
                if ("A".equals(fs.getType())) continue;
                FareInfo fareInfo = new FareInfo();
                fareInfo.setFareBasis(fs.getFareBasis());
                fareInfo.setPassengerType(passengerType);
                if (fs.getBaggage() != null && fs.getBaggage().getAllowance() != null) {
                    fareInfo.setLuggageInfo(GetReservationHelper.prepareLuggageInfo(fs.getBaggage()));
                }
                while (fareInfos.size() < i + 1) {
                    fareInfos.add(new HashSet());
                }
                if (ptcLuggageInfo != null || ptcCabinLuggageInfo != null) {
                    try {
                        List<String> key = Arrays.asList(fs.getFlight().getMarketingFlight().getString(), fs.getFlight().getDeparture().getDateTime().substring(0, 10), fs.getFlight().getMarketingFlight().getNumber(), fs.getFlight().getDeparture().getCityCode().getString(), fs.getFlight().getArrival().getCityCode().getString());
                        if (fareInfo.getFareDetails() == null) {
                            fareInfo.setFareDetails(new FareDetails());
                        }
                        if (ptcLuggageInfo != null) {
                            fareInfo.getFareDetails().setLuggageInfo(ptcLuggageInfo.get(key));
                        }
                        if (ptcCabinLuggageInfo != null) {
                            fareInfo.getFareDetails().setCabinLuggageInfo(ptcCabinLuggageInfo.get(key));
                        }
                    }
                    catch (Exception ex) {
                        IncidentsLog.reportException((String)"failed populating luggage/cabin luggage info", (Throwable)ex);
                    }
                }
                ((Collection)fareInfos.get(i)).add(fareInfo);
                if (localPqSegments != null) {
                    localPqSegments.add(fs);
                }
                ++i;
            }
            if (localPqSegments == null) continue;
            pqSegments = localPqSegments;
        }
        ArrayList oldFlightSegments = null;
        if (oldFlight != null) {
            oldFlightSegments = new ArrayList();
            for (FlightSegmentTariff oldFst : oldFlight.getSegmentTariffs()) {
                oldFlightSegments.addAll(oldFst.getSegments());
            }
        }
        boolean bl = false;
        while (var19_23 < flightSegments.size()) {
            FlightSegment fs = flightSegments.get((int)var19_23);
            if (oldFlightSegments != null) {
                fs.setStarting(((FlightSegment)oldFlightSegments.get((int)var19_23)).isStarting());
                fs.setOperatingAirlineCompanyShortName(((FlightSegment)oldFlightSegments.get((int)var19_23)).getOperatingAirlineCompanyShortName());
                if (SabreCustomPropertiesHelper.getMarriageGrp(fs) == null) {
                    SabreCustomPropertiesHelper.setMarriageGrp(fs, SabreCustomPropertiesHelper.getMarriageGrp((FlightSegment)oldFlightSegments.get((int)var19_23)));
                }
                if (fs.getTravelDuration() <= 0) {
                    fs.setTravelDuration(((FlightSegment)oldFlightSegments.get((int)var19_23)).getTravelDuration());
                }
            } else {
                assert (pqSegments != null);
                fs.setStarting("O".equals(((PriceQuoteDetailsSegmentInfo)pqSegments.get((int)var19_23)).getFlight().getConnectionIndicator()));
            }
            for (FareInfo fi : (Collection)fareInfos.get((int)var19_23)) {
                Map data = (Map)brandIds.get(fi.getPassengerType());
                String brandId = data.getOrDefault(fs.getGdsId(), null);
                GDSHelper.setBrandId((FareInfo)fi, (String)brandId);
                SabreRemarksSearchContext ctx = new SabreRemarksSearchContext();
                ctx.setPType(SabreHelper.getNativeCode((DictionaryReference)fi.getPassengerType()));
                ctx.setSegNumber(fs.getGdsId());
                fi.setRemarksSearchContext(XSUtil.toString((XSSerializable)ctx));
                fs.getFareInfos().add(fi);
            }
            ++var19_23;
        }
        try {
            flight.getSegmentTariffs().addAll(GDSHelper.buildFlightSegmentTariffs(flightSegments, (String)calcLine));
        }
        catch (Exception exception) {
            FlightSegmentTariff fst = new FlightSegmentTariff();
            fst.setGds(((SabreGdsAccount)accountCtr.getEntity()).getGds());
            fst.getSegments().addAll(flightSegments);
            flight.getSegmentTariffs().add(fst);
        }
        if (ancillaryFees != null) {
            flight.getAncillaryFees().addAll(ancillaryFees);
        }
        return flight;
    }

    private String getCalcLine(MessageContext ctx) {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        return GetReservationHelper.getValidPriceQuotes(response).get(0).getFareInfo().getFareCalculation().getString();
    }

    private static int getPassengerTypeQuantity(PriceQuoteDetails pq) {
        return Integer.parseInt(pq.getMiscellaneousInfo().getMiscellaneousDataList().stream().map(KeyValuePair::getValueList).flatMap(Collection::stream).filter(v -> v.getType().equals("paxTypeCountAtPricing")).findFirst().get().getString());
    }
}

