/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.selectFlight;

import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseConditionProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NNWaitConditionProvider
extends BaseConditionProvider {
    public boolean matches(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        HashSet<String> statuses = new HashSet<String>();
        HashMap<FlightSegment, String> segments = new HashMap<FlightSegment, String>();
        for (AirType air : GetReservationHelper.getAirs(response)) {
            statuses.add(air.getActionCode());
            if ("SS".equals(air.getActionCode())) continue;
            FlightSegment fs = GetReservationHelper.parseFlightSegment(air);
            segments.put(fs, air.getActionCode());
        }
        if (segments.size() > 0) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.NOT_CONFIRMED_SEGMENTS, segments);
        }
        boolean hasUnknown = statuses.contains("NN");
        boolean hasUnconfirmed = this.hasUnconfirmed(statuses);
        return hasUnknown && !hasUnconfirmed;
    }

    private boolean hasUnconfirmed(Set<String> statuses) {
        HashSet<String> col = new HashSet<String>(statuses);
        col.remove("NN");
        col.remove("SS");
        return !col.isEmpty();
    }
}

