/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.selectFlight;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class SeatsPreferencesAirPriceRQParametersProcessor
extends BaseProcessor {
    private boolean retain;
    private boolean airExtras;

    public void configure(Map<String, String> parameters) {
        this.retain = MiscUtil.isTrue((String)parameters.get("retain"));
        this.airExtras = MiscUtil.isTrue((String)parameters.get("air-extras"));
    }

    public void process(MessageContext ctx) throws Exception {
        final Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        final SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        final Boolean isSuOnBsp = SabreHelper.isSuOnBsp((Flight)flight, (SalesContext)salesContext);
        EntityReference specialTariffRef = flight.getSpecialTariff();
        final GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        ImmutableListMultimap spByUniqueQualifiers = Multimaps.index((Iterable)flight.getSeats(), (Function)new Function<SeatPreferences, AirPriceHelper.UniqueQualifiers>(){

            public AirPriceHelper.UniqueQualifiers apply(SeatPreferences sp) {
                try {
                    AirPriceHelper.UniqueQualifiers result = new AirPriceHelper.UniqueQualifiers();
                    result.commission = AirPriceHelper.buildCommissionQualifier(SabreHelper.getTotalVendorCommissionForSabre((Flight)flight, (DictionaryReference)sp.getPassengerType()), flight.getGdsCurrencyCode());
                    result.endorsement = SabreServerHelper.buildEndorsement(gdsParameters, flight, (DictionaryReference<PassengerType>)sp.getPassengerType(), salesContext, null, null);
                    result.suOnBsp = isSuOnBsp;
                    result.brandIds = AirPriceHelper.getBrandIds(flight, (DictionaryReference<PassengerType>)sp.getPassengerType());
                    if (flight.isSabreSmartPricePricing()) {
                        result.smartPriceFareBasises = AirPriceHelper.getSmartPriceFareBasises(flight, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType());
                    }
                    result.publicFare = AirPriceHelper.getPublicFare(flight, (DictionaryReference<PassengerType>)sp.getPassengerType());
                    result.refundableAny = AirPriceHelper.getRefundableAny(flight, (DictionaryReference<PassengerType>)sp.getPassengerType());
                    result.privateFare = Boolean.TRUE.equals(flight.getPrivateFare().get(sp.getPassengerType()));
                    result.vatInfo = SabreServerHelper.buildEndorsementVatInfo(flight, (DictionaryReference<PassengerType>)sp.getPassengerType());
                    return result;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        Comparator<SeatPreferences> spComparator = new Comparator<SeatPreferences>(){

            @Override
            public int compare(SeatPreferences sp1, SeatPreferences sp2) {
                String pt1 = SabreHelper.getNativeCode((DictionaryReference)sp1.getPassengerType());
                String pt2 = SabreHelper.getNativeCode((DictionaryReference)sp2.getPassengerType());
                return MiscUtil.compare((Comparable)((Object)pt1), (Comparable)((Object)pt2));
            }
        };
        ArrayList<AirPriceRQParameters> result = new ArrayList<AirPriceRQParameters>();
        for (Map.Entry entry : spByUniqueQualifiers.asMap().entrySet()) {
            AirPriceHelper.UniqueQualifiers uq = (AirPriceHelper.UniqueQualifiers)entry.getKey();
            ArrayList spsList = new ArrayList((Collection)entry.getValue());
            Collections.sort(spsList, spComparator);
            for (List atomicSps : Lists.partition(spsList, (int)4)) {
                AirPriceRQParameters parameters = new AirPriceRQParameters();
                parameters.setGdsAccount(flight.getGdsAccount());
                if (!StringUtils.isBlank((String)flight.getAccountCode())) {
                    parameters.getAccountCodes().add(flight.getAccountCode());
                }
                parameters.setCorporateId(flight.getCorporateId());
                if (gdsParameters.getValidatingCarrier() != null) {
                    parameters.setCarrier(gdsParameters.getValidatingCarrier());
                } else {
                    parameters.setCarrier(flight.getCarrier());
                }
                parameters.setGdsCurrencyCode(flight.getGdsCurrencyCode());
                parameters.setCommission(SabreHelper.getTotalVendorCommissionForSabre((Flight)flight, (DictionaryReference)((SeatPreferences)atomicSps.get(0)).getPassengerType()));
                for (SeatPreferences atomicSp : atomicSps) {
                    parameters.getPassengerTypes().add(new MiscUtil.Pair((Object)SabreHelper.getNativeCode((DictionaryReference)atomicSp.getPassengerType()), (Object)atomicSp.getCount()));
                }
                parameters.setRetain(this.retain);
                parameters.setTourCode(flight.getTourCode());
                parameters.setTripartiteContractDetails(flight.getTripartiteContractDetails());
                if (specialTariffRef != null) {
                    SpecialTariff specialTariff = (SpecialTariff)EntityStorage.get().resolve(specialTariffRef).getEntity();
                    parameters.setExemptAllTaxes(specialTariff.isExcludeTaxes());
                    parameters.setResidentCountry(specialTariff.getResidentCountry());
                }
                parameters.setEndorsement(uq.endorsement);
                for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
                    parameters.getSegmentNumbers().add(fs.getGdsId());
                }
                parameters.setAirExtras(this.airExtras);
                if (uq.brandIds != null) {
                    parameters.getBrandIds().addAll(uq.brandIds);
                }
                if (uq.smartPriceFareBasises != null) {
                    parameters.getSmartPriceFareBasises().addAll(uq.smartPriceFareBasises);
                }
                parameters.setPublicFare(uq.publicFare);
                parameters.setRefundableAny(uq.refundableAny);
                if (SabreHelper.isTchBlankOwner((EntityReference)flight.getBlankOwner())) {
                    parameters.setValidationMethod("TCH");
                }
                parameters.setVatInfo(uq.vatInfo);
                parameters.setSupplier(GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER));
                parameters.setBlankOwner(flight.getBlankOwner());
                result.add(parameters);
            }
        }
        if (result.size() > 1) {
            for (AirPriceRQParameters parameters : result) {
                parameters.setIncomplete(true);
            }
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.AIR_PRICE_RQ_PARAMETERS_SET, result);
    }
}

