/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.create;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.core.model.ISabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsResponse;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.opentravel.ota.SessionCreateRS;
import org.xmlsoap.schemas.ws.secext.Security;

public class SessionCreateResponseProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        WsResponse response = (WsResponse)ctx.getMandatoryObject((Enum)IBusJibxWsContextKeys.WS_RESPONSE);
        SessionCreateRS sessionCreateRS = (SessionCreateRS)response.getPayload();
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION, (Object)this.createSession(response, sessionCreateRS, accountCtr));
    }

    private SabreSession createSession(WsResponse response, SessionCreateRS sessionCreateRS, EntityContainer<?> accountCtr) {
        SabreSession result = new SabreSession();
        this.copyBinaryToken(response, result);
        result.setConversationId(sessionCreateRS.getConversationId());
        ISabreGdsAccount sabreGdsAccount = (ISabreGdsAccount)accountCtr.getEntity();
        result.setEndpointUrl(sabreGdsAccount.getAddress());
        String ipcc = sabreGdsAccount.getPrimaryPCC();
        result.setIpcc(ipcc);
        result.setPcc(ipcc);
        result.setLastModified(new Date());
        result.setUid(result.getConversationId());
        return result;
    }

    private void copyBinaryToken(WsResponse response, SabreSession result) {
        for (Object header : response.getHeaders()) {
            if (!(header instanceof Security)) continue;
            result.setBinarySecurityToken(((Security)header).getBinarySecurityToken());
            break;
        }
        if (StringUtils.isBlank((String)result.getBinarySecurityToken())) {
            throw Xeption.forDeveloper((String)"binary security token was not set: security header not found", (Object[])new Object[0]);
        }
    }
}

