/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.hold;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.core.helper.CoreSabreHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreResourceManagerFactory;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreSessionHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.util.Collections;

public class UnholdPoolSessionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SabreSession sabreSession = this.extractSession(flight);
        if (sabreSession != null) {
            sabreSession.setUnheld(true);
            ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION, (Object)sabreSession);
        }
        this.checkSabreSession(ctx);
        if (sabreSession != null) {
            CoreSabreHelper.SESSIONS_LOG.debug(String.format("unheld %s", sabreSession.getConversationId()));
        }
    }

    private void checkSabreSession(MessageContext ctx) {
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        if (session == null) {
            this.log.info("session not available");
        }
    }

    private SabreSession extractSession(Flight flight) throws Exception {
        String sessionUid = SabreSessionHelper.getSessionUid(flight);
        this.log.debug("Extract session pccData, flight " + flight.getUid());
        if (TextUtil.isBlank((String)sessionUid)) {
            return null;
        }
        return (SabreSession)this.getPoolManager().get(sessionUid, (PooledResourceManager)SabreResourceManagerFactory.create(SabreSessionHelper.getPccData(sessionUid), Collections.emptyMap()));
    }

    protected PoolManager getPoolManager() {
        return (PoolManager)Environment.getPublished(PoolManager.class);
    }
}

