/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.session.pool.PccDataProvider;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreResourceManagerFactory;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AcquireSessionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PccDataProvider.PccData pccData = new PccDataProvider(ctx).getData();
        SabreSession session = (SabreSession)this.getPoolManager().acquire((PooledResourceManager)SabreResourceManagerFactory.create(pccData, this.createInitData(ctx, pccData)), 60L, TimeUnit.SECONDS);
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Session acquired, thread [%s]\n%s", Thread.currentThread().getName(), session));
        }
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION, (Object)session);
        SabreHelper.SESSIONS_LOG.debug(String.format("acquired %s", session.getConversationId()));
    }

    protected PoolManager getPoolManager() {
        return (PoolManager)Environment.getPublished(PoolManager.class);
    }

    private Map<String, Object> createInitData(MessageContext ctx, PccDataProvider.PccData pccData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(IBusGdsContextKeys.GDS_PARAMETERS.name(), ctx.getObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS));
        data.put(IBusMidofficeContextKeys.GDS_ACCOUNT.name(), ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT));
        if (!pccData.getIppc().equalsIgnoreCase(pccData.getPcc())) {
            data.put(IBusGdsSabreContextKeys.CONTEXT_CHANGE_PCC.name(), pccData.getPcc());
        }
        return data;
    }
}

