/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;

public class PccDataProvider {
    private final MessageContext context;
    private final EntityContainer<SabreGdsAccount> gdsAccount;

    public PccDataProvider(MessageContext context) {
        this.context = context;
        this.gdsAccount = (EntityContainer)context.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
    }

    public PccData getData() {
        String ipcc = ((SabreGdsAccount)this.gdsAccount.getEntity()).getPrimaryPCC();
        String pcc = this.getPcc(ipcc);
        return new PccData(ipcc, pcc);
    }

    private String getPcc(String ipcc) {
        String pcc = (String)this.context.getObject((Enum)IBusGdsSabreContextKeys.RESULT_PCC);
        if (pcc == null) {
            return ipcc;
        }
        return pcc;
    }

    public static class PccData {
        private String ippc;
        private String pcc;

        public PccData(String ippc, String pcc) {
            Objects.requireNonNull(ippc);
            Objects.requireNonNull(pcc);
            this.ippc = ippc;
            this.pcc = pcc;
        }

        public PccData(SabreSession session) {
            this(session.getIpcc(), session.getPcc());
        }

        public String getIppc() {
            return this.ippc;
        }

        public String getPcc() {
            return this.pcc;
        }
    }
}

