/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.session.pool.PccDataProvider;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreResourceManagerFactory;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReleaseSessionProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreSession session = (SabreSession)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        PccDataProvider.PccData pccData = new PccDataProvider.PccData(session);
        if (session.isRemove()) {
            ((PoolManager)Environment.getPublished(PoolManager.class)).remove((Identity)session, (PooledResourceManager)SabreResourceManagerFactory.create(pccData, this.createInitData(ctx)), 60L, TimeUnit.SECONDS);
            this.log.info(String.format("Session removed, thread [%s]\n%s", Thread.currentThread().getName(), session));
            SabreHelper.SESSIONS_LOG.debug(String.format("removed %s", session.getConversationId()));
        } else {
            ((PoolManager)Environment.getPublished(PoolManager.class)).release((Identity)session, (PooledResourceManager)SabreResourceManagerFactory.create(pccData, this.createInitData(ctx)), 60L, TimeUnit.SECONDS);
            this.log.info(String.format("Session released, thread [%s]\n%s", Thread.currentThread().getName(), session));
            SabreHelper.SESSIONS_LOG.debug(String.format("released %s", session.getConversationId()));
        }
    }

    private Map<String, Object> createInitData(MessageContext ctx) {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        initData.put(IBusGdsContextKeys.GDS_PARAMETERS.name(), ctx.getObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS));
        initData.put(IBusMidofficeContextKeys.GDS_ACCOUNT.name(), ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT));
        return initData;
    }
}

