/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreSessionHelper;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreSessionPoolHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SabrePoolResourceManager
implements PooledResourceManager<SabreSession> {
    public static final int SESSION_LIFETIME_MINUTES = 15;
    public static final int SESSION_EXPIRED_PERIOD_MINUTES = 14;
    public static final int POOL_OPERATION_TIMELIMIT_SECONDS = 60;
    private static final int POOL_SIZE = 1000;
    private final Logger log = LoggerFactory.getLogger(SabrePoolResourceManager.class);
    private final String iPcc;
    private final String pcc;
    private ExecuteBusStrategy busExecutor = (data, routeId) -> IntegrationBusFacade.get().processRouteSync(routeId, data);

    public SabrePoolResourceManager(String iPcc, String pcc) {
        this.iPcc = iPcc;
        this.pcc = pcc;
        this.validateInitParams(iPcc, pcc);
    }

    public Logger getLog() {
        return this.log;
    }

    public void setBusExecutor(ExecuteBusStrategy busExecutor) {
        this.busExecutor = busExecutor;
    }

    public String getPoolId() {
        return String.format("%s_%s_%s", SabrePoolResourceManager.class.getName(), this.iPcc, this.pcc);
    }

    public int getSize() {
        return 1000;
    }

    public SabreSession createNew(long time, TimeUnit unit) throws Exception {
        ExecutorServiceFacade service = (ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class);
        Future future = service.submit(this::createNewSessionInternal);
        try {
            SabreSession session = (SabreSession)future.get(time, unit);
            this.log.trace("CreateNew session, thread {}\n", (Object)Thread.currentThread().getName(), (Object)session);
            return session;
        }
        catch (Exception ex) {
            future.cancel(true);
            this.log.error("createNew session exception, thread {}", (Object)Thread.currentThread().getName(), (Object)ex);
            throw ex;
        }
    }

    public void expired(SabreSession session, long time, TimeUnit unit) throws Exception {
        if (this.isGdsRelease(session)) {
            this.gdsRelease(session, time, unit);
        }
    }

    public long acquired(SabreSession session, long time, TimeUnit unit) throws Exception {
        long result = session.getLastModified().getTime() + 840000L;
        this.log.trace("acquired, result {}, thread {}\n{}", new Object[]{SabreSessionPoolHelper.formatDate(result), Thread.currentThread().getName(), session});
        return result;
    }

    public long released(SabreSession session, long time, TimeUnit unit) throws Exception {
        long result = session.getLastModified().getTime() + 840000L;
        this.log.trace("released, result {}, thread {}\n{}", new Object[]{SabreSessionPoolHelper.formatDate(result), Thread.currentThread().getName(), session});
        return result;
    }

    public long touched(SabreSession session, long time, TimeUnit unit) throws Exception {
        long result = session.getLastModified().getTime() + 840000L;
        this.log.trace("touched, result {}, thread {}\n{}", new Object[]{SabreSessionPoolHelper.formatDate(result), Thread.currentThread().getName(), session});
        return result;
    }

    public abstract Map<String, Object> getInitialData();

    private SabreSession createNewSessionInternal() {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>(this.getInitialData());
            this.executeBusRoute(data, "gds:sabre:pool-session-create-route");
            SabreSession session = (SabreSession)data.get(IbusGdsSabreCoreContextKeys.SABRE_SESSION.name());
            SabreSessionHelper.updateSessionPoolUid(session);
            return session;
        }
        catch (IntegrationBusException e) {
            this.log.error("IntegrationBusException", (Throwable)e);
            throw e;
        }
    }

    protected boolean isGdsRelease(SabreSession session) {
        Period period = new Period(session.getLastModified().getTime(), new Date().getTime());
        boolean isGdsRelease = period.getMinutes() <= 15;
        this.log.trace("Expired session, isGdsRelease {}, periods {}min thread {}\n{}", new Object[]{isGdsRelease, period.getMinutes(), Thread.currentThread().getName(), session});
        return isGdsRelease;
    }

    protected void gdsRelease(SabreSession session, long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorServiceFacade service = (ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class);
        Future future = service.submit(() -> {
            try {
                HashMap<String, Object> data = new HashMap<String, Object>(this.getInitialData());
                data.put(IbusGdsSabreCoreContextKeys.SABRE_SESSION.name(), session);
                this.executeBusRoute(data, "gds:sabre:pool-session-close-route");
            }
            catch (IntegrationBusException e) {
                this.log.error("IntegrationBusException", (Throwable)e);
                throw e;
            }
        });
        try {
            future.get(time, unit);
            this.log.trace("Expired session, thread {}\n{}", (Object)Thread.currentThread().getName(), (Object)session);
        }
        catch (Exception ex) {
            future.cancel(true);
            this.log.error("Session expired exception, thread {}", (Object)Thread.currentThread().getName(), (Object)ex);
            throw ex;
        }
    }

    private void validateInitParams(String iPcc, String pcc) {
        if (StringUtils.isBlank((String)iPcc) || StringUtils.isBlank((String)pcc)) {
            throw Xeption.forAdmin((String)"Blank ipcc or pcc", (Object[])new Object[0]);
        }
    }

    private void executeBusRoute(Map<String, Object> data, String routeId) {
        String busParams = data.entrySet().stream().map(entry -> new StringBuilder((String)entry.getKey()).append("=").append(entry.getValue() != null ? entry.getValue() : "null")).collect(Collectors.joining(","));
        this.log.trace("execute bus route {}, parameters\n{}", (Object)routeId, (Object)busParams);
        this.busExecutor.processSync(data, routeId);
    }

    @FunctionalInterface
    public static interface ExecuteBusStrategy {
        public void processSync(Map<String, Object> var1, String var2);
    }
}

