/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.sabre.session.pool.PccDataProvider;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabreSessionHelper {
    private static final String SESSION_UID = "sessionUid";
    private static Logger log = LoggerFactory.getLogger(SabreSessionHelper.class);

    public static void saveSessionUid(Flight flight, SabreSession session) {
        log.debug("Save session uid in flight {}\n{}", (Object)flight.getUid(), (Object)session);
        NamedValueHelper.setValueForName((String)SESSION_UID, (String)session.getUid(), (Collection)flight.getCustomProperties());
    }

    public static String getSessionUid(Flight flight) throws Exception {
        String value = NamedValueHelper.getValueForName((String)SESSION_UID, (Collection)flight.getCustomProperties());
        if (value == null && log.isTraceEnabled()) {
            log.trace("Null session uid in flight:\n" + XSUtil.toString((XSSerializable)flight));
        }
        return value;
    }

    public static void updateSessionPoolUid(SabreSession session) {
        session.setUid(session.getUid() + ";" + session.getIpcc() + ";" + session.getPcc());
        log.debug("Updated session uid with pcc data\n{}", (Object)session);
    }

    public static PccDataProvider.PccData getPccData(String uid) {
        log.debug("extract pcc data from uid {}", (Object)uid);
        String[] values = uid.split(";");
        return new PccDataProvider.PccData(values[1], values[2]);
    }
}

