/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabrePoolResourceManager;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreResourceManagerFactory;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreResourcePoolInfo;
import com.gridnine.xtrip.server.pool.PoolManager;
import com.gridnine.xtrip.server.pool.PoolManagerMaintaince;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SabreSessionPoolHelper {
    private static Logger log = LoggerFactory.getLogger(SabreSessionPoolHelper.class);

    public static String formatDate(long date) {
        return SabreSessionPoolHelper.formatDate(new Date(date));
    }

    public static void releaseAcquiredAndExpired(String ipcc, String pcc) {
        new PoolManagerMaintaince().releaseAcquiredAndExpired((PooledResourceManager)SabreResourceManagerFactory.create(ipcc, pcc), SabreSessionPoolHelper.getLimit(), 60);
    }

    public static int getAcquiredSessions(String ipcc, String pcc) throws Exception {
        long acquiredSessions = new PoolManagerMaintaince().getAcquiredSessions((PooledResourceManager)SabreResourceManagerFactory.create(ipcc, pcc));
        log.trace("ipcc {} pcc {}, acquired sessions {}", new Object[]{ipcc, pcc, acquiredSessions});
        return (int)acquiredSessions;
    }

    private static Date getLimit() {
        return DateUtils.addMinutes((Date)new Date(System.currentTimeMillis()), (int)-17);
    }

    private static String formatDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss dd.MM");
        return dateFormatter.format(date);
    }

    private static Collection<SabreSession> getAllSessions(String ipcc, String pcc) throws Exception {
        return ((PoolManager)Environment.getPublished(PoolManager.class)).resources((PooledResourceManager)SabreResourceManagerFactory.create(ipcc, pcc));
    }

    static void releaseAllSessions(String ipcc, String pcc) throws Exception {
        SabreSessionPoolHelper.getAllSessions(ipcc, pcc).forEach(resource -> SabreSessionPoolHelper.releaseSession(resource.getUid(), ipcc, pcc));
    }

    static void releaseSession(String uid, String ipcc, String pcc) {
        try {
            ((PoolManager)Environment.getPublished(PoolManager.class)).release(uid, (PooledResourceManager)SabreResourceManagerFactory.create(ipcc, pcc), 60L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.warn("releaseSession timeout exception", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("releaseSession exception", (Throwable)e);
        }
    }

    static void removeSession(String uid, String ipcc, String pcc) {
        try {
            SabrePoolResourceManager manager = SabreResourceManagerFactory.create(ipcc, pcc);
            new PoolManagerMaintaince().removeSession((PooledResourceManager)manager, uid, SabreResourcePoolInfo::new, 60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("removeSession exception", (Throwable)e);
        }
    }
}

