/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.xtrip.common.jmx.AbstractAnnotatedJmxBean;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreSessionPoolHelper;
import org.weakref.jmx.Managed;

public class SabreSessionPoolJmxBean
extends AbstractAnnotatedJmxBean {
    private static final String DEFAULT_APP_NAME = "Midoffice";
    private final String appName;

    public SabreSessionPoolJmxBean() {
        this.appName = DEFAULT_APP_NAME;
    }

    public SabreSessionPoolJmxBean(String appName) {
        this.appName = !TextUtil.isBlank((String)appName) ? appName : DEFAULT_APP_NAME;
    }

    @Managed(description="Get number of aqcuired sessions for given pcc")
    public int getAcquiredSessionCount(String ipcc, String pcc) throws Exception {
        if (TextUtil.isBlank((String)ipcc) || TextUtil.isBlank((String)pcc)) {
            throw new IllegalArgumentException();
        }
        return SabreSessionPoolHelper.getAcquiredSessions(ipcc, pcc);
    }

    @Managed(description="Release all aqcuired sessions for given pcc")
    public void releaseAllSessions(String ipcc, String pcc) throws Exception {
        SabreSessionPoolHelper.releaseAllSessions(ipcc, pcc);
    }

    protected String getOname() {
        return this.appName + ":00=GdsSessions,name=Sabre";
    }
}

