/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.session.pool;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreResourceManagerFactory;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreResourcePoolInfo;
import com.gridnine.xtrip.server.gds.sabre.session.pool.SabreSessionPoolHelper;
import com.gridnine.xtrip.server.pool.PoolManagerMaintaince;
import com.gridnine.xtrip.server.pool.PooledResourceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabreSessionPoolServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(SabreSessionPoolServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sessionUid;
        String command = request.getParameter("command");
        String ipcc = request.getParameter("ipcc");
        String pcc = request.getParameter("pcc");
        request.setAttribute("ipcc", (Object)ipcc);
        request.setAttribute("pcc", (Object)pcc);
        if ("release-session".equals(command)) {
            sessionUid = request.getParameter("session.uid");
            SabreSessionPoolHelper.releaseSession(sessionUid, ipcc, pcc);
        }
        if ("remove-session".equals(command)) {
            sessionUid = request.getParameter("session.uid");
            SabreSessionPoolHelper.removeSession(sessionUid, ipcc, pcc);
        }
        request.setAttribute("models", this.getSortedSessions(ipcc, pcc));
        this.defaultHttpProcess(request, response);
    }

    private void defaultHttpProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        request.getRequestDispatcher("WEB-INF/jsp/sabre-sessions-pool.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    private List<SabreResourcePoolInfo> getSortedSessions(String ipcc, String pcc) {
        if (TextUtil.isBlank((String)ipcc) || TextUtil.isBlank((String)pcc)) {
            return Collections.emptyList();
        }
        try {
            Collection infos = new PoolManagerMaintaince().collectSessionData((PooledResourceManager)SabreResourceManagerFactory.create(ipcc, pcc), SabreResourcePoolInfo::new);
            ArrayList<SabreResourcePoolInfo> result = new ArrayList<SabreResourcePoolInfo>(infos);
            Comparator<SabreResourcePoolInfo> comparator = Comparator.comparingLong(value -> value.getResource().getCreated().getTime());
            Collections.sort(result, comparator);
            return result;
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"error get session", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

