/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.splitReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.TravelItineraryDivideRQ;
import java.util.Collection;
import java.util.stream.Collectors;

public class TravelItineraryDivideRQDivideBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection productUidsToSplit = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT_UIDS_TO_SPLIT);
        TravelItineraryDivideRQ request = this.buildRequest(reservation, productUidsToSplit);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"TravelItineraryDivideLLSRQ");
        ctx.putObject((Enum)IBusGdsSabreContextKeys.SPLIT_GDS_IDS, request.getDivide().getCustomerInfo().getPersonNameList().stream().map(pn -> pn.getNameNumber()).collect(Collectors.toList()));
    }

    private TravelItineraryDivideRQ buildRequest(Reservation reservation, Collection<String> productUidsToSplit) {
        TravelItineraryDivideRQ request = new TravelItineraryDivideRQ();
        request.setVersion("2.0.3");
        request.setReturnHostCommand(Boolean.TRUE);
        TravelItineraryDivideRQ.Divide divide = new TravelItineraryDivideRQ.Divide();
        TravelItineraryDivideRQ.Divide.CustomerInfo ci = new TravelItineraryDivideRQ.Divide.CustomerInfo();
        for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
            if (!productUidsToSplit.contains(prod.getUid())) continue;
            TravelItineraryDivideRQ.Divide.CustomerInfo.PersonName pn = new TravelItineraryDivideRQ.Divide.CustomerInfo.PersonName();
            pn.setNameNumber(prod.getGdsId());
            ci.getPersonNameList().add(pn);
        }
        divide.setCustomerInfo(ci);
        request.setDivide(divide);
        return request;
    }
}

