/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.splitReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.exceptions.NoAirlineLocatorException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

public class UpdateSplitReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        ArrayList<String> airlineLocators = new ArrayList<String>();
        for (AirType airType : GetReservationHelper.getAirs(response)) {
            Matcher airlineLocatorMatcher = GetReservationHelper.PATTERN_SUPPLIER_REF.matcher(airType.getAirlineRefId());
            if (airlineLocatorMatcher.matches()) {
                airlineLocators.add(airlineLocatorMatcher.group(1));
                continue;
            }
            throw new NoAirlineLocatorException();
        }
        Reservation splitReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SPLIT_RESERVATION);
        for (Product prod : GDSHelper.getProducts((Reservation)splitReservation)) {
            Iterator iter = airlineLocators.iterator();
            for (Segment s : AirProductHelper.getSegments((Collection)prod.getSegmentTariffs())) {
                String newAirlineLocator = (String)iter.next();
                if (newAirlineLocator.equals(s.getAirlineLocator())) {
                    throw Xeption.forDeveloper((String)"airline locator {0} hasn't changed", (Object[])new Object[]{newAirlineLocator});
                }
                s.setAirlineLocator(newAirlineLocator);
            }
        }
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List splitGdsIds = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.SPLIT_GDS_IDS);
        UpdateSplitReservationProcessor.updateGdsIds(reservation, splitReservation, splitGdsIds);
    }

    public static void updateGdsIds(Reservation reservation, Reservation splitReservation, List<String> splitGdsIds) {
        HashMap<String, Product> gdsId2Product = new HashMap<String, Product>();
        ArrayList<BigDecimal> gdsIds = new ArrayList<BigDecimal>();
        for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
            gdsId2Product.put(prod.getGdsId(), prod);
            gdsIds.add(new BigDecimal(prod.getGdsId()));
        }
        for (Product prod : GDSHelper.getProducts((Reservation)splitReservation)) {
            gdsId2Product.put(prod.getGdsId(), prod);
            gdsIds.add(new BigDecimal(prod.getGdsId()));
        }
        Collections.sort(gdsIds);
        int idx = 1;
        for (String splitGdsId : splitGdsIds) {
            ((Product)gdsId2Product.get(splitGdsId)).setGdsId(String.format("%d.1", idx++));
            for (int i = gdsIds.indexOf(new BigDecimal(splitGdsId)) + 1; i < gdsIds.size(); ++i) {
                BigDecimal gdsId = (BigDecimal)gdsIds.get(i);
                if (splitGdsIds.contains(gdsId.toString())) continue;
                Product prod = (Product)gdsId2Product.get(gdsId.toString());
                prod.setGdsId(new BigDecimal(prod.getGdsId()).subtract(BigDecimal.ONE).toString());
            }
        }
    }
}

