/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ssr;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.ssr.SsrInner;
import com.sabre.webservices.pnrbuilder.v119.GenericSpecialRequestPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import com.sabre.webservices.pnrbuilder.v119.RequestTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.SeatRequestPNRB;
import com.sabre.webservices.pnrbuilder.v119.SpecialMealRequestPNRB;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class SabreSsrHelper {
    public static final Pattern SSR_FREE_TEXT_PATTERN = Pattern.compile("([A-Z0-9]{2} )?([A-Z]{2})1 ([^ /\\.]+).*");
    private static final DateFormat formatter = new SimpleDateFormat("yyyy-mm-dd");
    private static final FastDateFormat DF_SSR_SEG_STRING_DATE = FastDateFormat.getInstance((String)"ddMMM", (Locale)Locale.ENGLISH);

    public static Map<DictionaryReference<SpecialServiceRequestDict>, MiscUtil.Pair<SsrInner, SsrInner>> getSsrData(GetReservationRSType response, Product product, Segment s) throws Exception {
        HashMap<DictionaryReference<SpecialServiceRequestDict>, MiscUtil.Pair<SsrInner, SsrInner>> result = new HashMap<DictionaryReference<SpecialServiceRequestDict>, MiscUtil.Pair<SsrInner, SsrInner>>();
        for (PassengerPNRB passenger : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
            if (!product.getGdsId().equals(passenger.getNameId().replaceAll("0+", "")) || passenger.getSpecialRequests() == null) continue;
            ArrayList<SsrInner> ssrList = new ArrayList<SsrInner>();
            List specialMealRequestList = passenger.getSpecialRequests().getSpecialMealRequestList();
            List seatRequestList = passenger.getSpecialRequests().getSeatRequestList();
            List genericSpecialRequestList = passenger.getSpecialRequests().getGenericSpecialRequestList();
            if (genericSpecialRequestList != null) {
                for (GenericSpecialRequestPNRB req : genericSpecialRequestList) {
                    ssrList.add(new SsrInner(req));
                }
            }
            if (specialMealRequestList != null) {
                for (SpecialMealRequestPNRB mealSSR : specialMealRequestList) {
                    ssrList.add(new SsrInner(mealSSR));
                }
            }
            if (seatRequestList != null) {
                for (SeatRequestPNRB seatSSR : seatRequestList) {
                    ssrList.add(new SsrInner(seatSSR));
                }
            }
            for (SsrInner ssr : ssrList) {
                String expectedSegString;
                String actualSegString;
                Matcher ssrFreeTextMatcher;
                DictionaryReference ssrRef;
                if (StringUtils.isBlank((String)ssr.getCode()) || (ssrRef = SabreHelper.resolveNativeCode(SpecialServiceRequestDict.class, (String)ssr.getCode(), (boolean)false, (boolean)false)) == null || ssr.getFullText() == null || ssr.getFullText().isEmpty() || !(ssrFreeTextMatcher = SSR_FREE_TEXT_PATTERN.matcher(ssr.getFullText())).matches() || !(actualSegString = ssrFreeTextMatcher.group(3)).equals(expectedSegString = SabreSsrHelper.buildExpectedSsrSegString(s))) continue;
                if (!result.containsKey(ssrRef)) {
                    result.put((DictionaryReference<SpecialServiceRequestDict>)ssrRef, (MiscUtil.Pair<SsrInner, SsrInner>)new MiscUtil.Pair());
                }
                if (RequestTypePNRB.A == ssr.getType()) {
                    ((MiscUtil.Pair)result.get(ssrRef)).setSecond((Object)ssr);
                    continue;
                }
                if (RequestTypePNRB.G != ssr.getType()) continue;
                ((MiscUtil.Pair)result.get(ssrRef)).setFirst((Object)ssr);
            }
        }
        result.entrySet().removeIf(entry -> ((MiscUtil.Pair)entry.getValue()).getFirst() == null);
        return result;
    }

    private static String buildExpectedSsrSegString(Segment s) {
        StringBuilder sb = new StringBuilder();
        sb.append(SabreHelper.getNativeCode((DictionaryReference)s.getDepartureLocation()));
        sb.append(SabreHelper.getNativeCode((DictionaryReference)s.getArriveLocation()));
        sb.append(("0000" + s.getFlightNo()).substring(s.getFlightNo().length()));
        sb.append(s.getClassOfSvcCode());
        sb.append(DF_SSR_SEG_STRING_DATE.format(s.getStartDate()).toUpperCase());
        return sb.toString();
    }
}

