/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ssr;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.SegmentSpecialServiceRequest;
import com.gridnine.xtrip.common.gds.model.TravellerModifySsrsParameters;
import com.gridnine.xtrip.common.gds.model.TravellersModifySsrsParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.SpecialServiceRQ;

public class SpecialServiceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        TravellersModifySsrsParameters parameters = (TravellersModifySsrsParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.MODIFY_SSRS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)this.buildRequest(parameters, reservation));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"SpecialServiceLLSRQ");
    }

    private SpecialServiceRQ buildRequest(TravellersModifySsrsParameters parameters, Reservation reservation) {
        SpecialServiceRQ request = new SpecialServiceRQ();
        request.setVersion("2.3.1");
        request.setReturnHostCommand(Boolean.TRUE);
        for (TravellerModifySsrsParameters tp : parameters.getModifySsrs()) {
            Product product = BookingHelper.findAirProductByTravellerUid((Reservation)reservation, (String)tp.getTravellerUid());
            for (SegmentSpecialServiceRequest sssr : tp.getAddSsrs()) {
                Segment s = AirProductHelper.findSegmentByUid((Product)product, (String)sssr.getSegmentUid());
                SpecialServiceRQ.Service service = new SpecialServiceRQ.Service();
                service.setSSRCode(SabreHelper.getNativeCode((DictionaryReference)sssr.getSpecialServiceRequest().getType()));
                service.setSegmentNumber(s.getGdsId());
                SpecialServiceRQ.Service.PersonName pn = new SpecialServiceRQ.Service.PersonName();
                pn.setNameNumber(product.getGdsId());
                service.setPersonName(pn);
                service.setText(sssr.getSpecialServiceRequest().getRequestFreeText());
                request.getServiceList().add(service);
            }
        }
        return request;
    }
}

