/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ssr;

import com.sabre.webservices.pnrbuilder.v119.GenericSpecialRequestPNRB;
import com.sabre.webservices.pnrbuilder.v119.MsgTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.OperationTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.RequestTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.SeatRequestPNRB;
import com.sabre.webservices.pnrbuilder.v119.SpecialMealRequestPNRB;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SsrInner {
    private String code;
    private String freeText;
    private String actionCode;
    private BigInteger numberInParty;
    private String airlineCode;
    private String ticketNumber;
    private String fullText;
    private String id;
    private RequestTypePNRB type;
    private MsgTypePNRB msgType;
    private OperationTypePNRB op;
    private String RPH;

    SsrInner(SeatRequestPNRB seatSSRs) throws Exception {
        this.actionCode = seatSSRs.getActionCode();
        this.RPH = seatSSRs.getRPH();
        this.id = seatSSRs.getId();
        this.type = seatSSRs.getType();
        this.code = seatSSRs.getSeatCode();
        this.airlineCode = seatSSRs.getVendorCode();
        this.numberInParty = seatSSRs.getNumberInParty();
        this.op = seatSSRs.getOp();
        this.fullText = this.buildFullText(seatSSRs.getActionCode(), seatSSRs.getNumberInParty().toString(), seatSSRs.getBoardCity(), seatSSRs.getOffCity(), seatSSRs.getFlightNumber(), seatSSRs.getClassOfService(), seatSSRs.getFlightDate(), seatSSRs.getComment());
    }

    SsrInner(SpecialMealRequestPNRB mealSSR) throws Exception {
        this.actionCode = mealSSR.getActionCode();
        this.RPH = mealSSR.getRPH();
        this.id = mealSSR.getId();
        this.type = mealSSR.getType();
        this.code = mealSSR.getMealType();
        this.airlineCode = mealSSR.getVendorCode();
        this.numberInParty = mealSSR.getNumberInParty();
        this.op = mealSSR.getOp();
        this.fullText = this.buildFullText(mealSSR.getActionCode(), mealSSR.getNumberInParty().toString(), mealSSR.getBoardCity(), mealSSR.getOffCity(), mealSSR.getFlightNumber(), mealSSR.getClassOfService(), mealSSR.getFlightDate(), mealSSR.getComment());
    }

    SsrInner(GenericSpecialRequestPNRB genericSSR) throws Exception {
        this.actionCode = genericSSR.getActionCode();
        this.RPH = genericSSR.getRPH();
        this.id = genericSSR.getId();
        this.type = genericSSR.getType();
        this.code = genericSSR.getCode();
        this.numberInParty = genericSSR.getNumberInParty();
        this.op = genericSSR.getOp();
        this.freeText = genericSSR.getFreeText();
        this.msgType = genericSSR.getMsgType();
        this.ticketNumber = genericSSR.getTicketNumber();
        this.airlineCode = genericSSR.getAirlineCode();
        this.fullText = this.changeFullText(genericSSR);
    }

    private String buildFullText(String actCode, String numInParty, String boardCity, String offCity, String flightNumber, String classOfService, String date, String freeText) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(actCode);
        sb.append(numInParty);
        sb.append(" ");
        sb.append(boardCity);
        sb.append(offCity);
        sb.append(flightNumber);
        sb.append(classOfService);
        sb.append(SsrInner.convertDate(date));
        if (freeText != null && !freeText.isEmpty()) {
            sb.append("/");
            sb.append(freeText);
        }
        return sb.toString();
    }

    private String changeFullText(GenericSpecialRequestPNRB req) {
        String result = null;
        if (req != null && req.getFullText() != null && req.getCode() != null) {
            result = req.getFullText().startsWith(req.getCode()) ? req.getFullText().substring(8) : req.getFullText();
        }
        return result;
    }

    private static String convertDate(String dateString) throws Exception {
        SimpleDateFormat inputFormatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = inputFormatter.parse(dateString);
        SimpleDateFormat outFormatter = new SimpleDateFormat("ddMMM", Locale.ENGLISH);
        return outFormatter.format(date).toUpperCase();
    }

    public String getCode() {
        return this.code;
    }

    public String getFreeText() {
        return this.freeText;
    }

    public String getActionCode() {
        return this.actionCode;
    }

    public BigInteger getNumberInParty() {
        return this.numberInParty;
    }

    public String getAirlineCode() {
        return this.airlineCode;
    }

    public String getTicketNumber() {
        return this.ticketNumber;
    }

    public String getFullText() {
        return this.fullText;
    }

    public String getId() {
        return this.id;
    }

    public RequestTypePNRB getType() {
        return this.type;
    }

    public MsgTypePNRB getMsgType() {
        return this.msgType;
    }

    public OperationTypePNRB getOp() {
        return this.op;
    }

    public String getRPH() {
        return this.RPH;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    public void setMsgType(MsgTypePNRB msgType) {
        this.msgType = msgType;
    }

    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}

