/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ssr;

import com.google.common.collect.HashMultimap;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.TravellerModifySsrsParameters;
import com.gridnine.xtrip.common.gds.model.TravellersModifySsrsParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.ssr.SabreSsrHelper;
import com.gridnine.xtrip.server.gds.sabre.ssr.SsrInner;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.OperationTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.RequestEnumerationType;
import com.sabre.webservices.pnrbuilder.v119.RequestType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateItemType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateListType;
import com.sabre.webservices.pnrbuilder.v119.ReturnOptions;
import com.sabre.webservices.pnrbuilder.v119.SpecialServiceRequestUpdatePNRB;
import com.sabre.webservices.pnrbuilder.v119.UpdateReservationRQ;
import java.util.ArrayList;
import java.util.Map;

public class UpdateReservationRQDeleteSSRBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        TravellersModifySsrsParameters parameters = (TravellersModifySsrsParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.MODIFY_SSRS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)this.buildRequest(parameters, reservation, response));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"UpdateReservationRQ");
    }

    private UpdateReservationRQ buildRequest(TravellersModifySsrsParameters parameters, Reservation reservation, GetReservationRSType response) throws Exception {
        UpdateReservationRQ request = new UpdateReservationRQ();
        request.setVersion("1.19.11");
        RequestType requestType = new RequestType();
        ReturnOptions returnOptions = new ReturnOptions();
        returnOptions.setViewName("Full");
        returnOptions.setRetrievePNR(Boolean.valueOf(true));
        returnOptions.setIncludeUpdateDetails(Boolean.valueOf(true));
        requestType.setCommitTransaction(Boolean.TRUE);
        requestType.setRequestEnumerationType(RequestEnumerationType.STATEFUL);
        request.setRequestType(requestType);
        request.setReservationUpdateList(new ReservationUpdateListType());
        request.getReservationUpdateList().setChoice(new ReservationUpdateListType.Choice());
        request.getReservationUpdateList().getChoice().setReservationUpdateItemList(new ArrayList());
        for (TravellerModifySsrsParameters tp : parameters.getModifySsrs()) {
            Product product = BookingHelper.findAirProductByTravellerUid((Reservation)reservation, (String)tp.getTravellerUid());
            HashMultimap data = HashMultimap.create();
            for (String ssrUid : tp.getRemoveSsrs()) {
                MiscUtil.Pair segmentAndSsr = AirProductHelper.findSegmentAndSsr((Product)product, (String)ssrUid);
                data.put(segmentAndSsr.getFirst(), segmentAndSsr.getSecond());
            }
            for (Segment s : data.keySet()) {
                Map<DictionaryReference<SpecialServiceRequestDict>, MiscUtil.Pair<SsrInner, SsrInner>> ssrData = SabreSsrHelper.getSsrData(response, product, s);
                int id = 1;
                for (SpecialServiceRequest req : data.get((Object)s)) {
                    ReservationUpdateItemType item = new ReservationUpdateItemType();
                    item.setUpdateId(Integer.toString(id));
                    SpecialServiceRequestUpdatePNRB service = new SpecialServiceRequestUpdatePNRB();
                    service.setId(((SsrInner)ssrData.get(req.getType()).getFirst()).getId());
                    service.setOp(OperationTypePNRB.D);
                    item.setSpecialServiceRequestUpdate(service);
                    request.getReservationUpdateList().getChoice().getReservationUpdateItemList().add(item);
                    ++id;
                }
            }
        }
        return request;
    }
}

