/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ssr;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestStatus;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.ssr.SabreSsrHelper;
import com.gridnine.xtrip.server.gds.sabre.ssr.SsrInner;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class UpdateSsrsProcessor
extends BaseProcessor {
    private static final Set<String> CONFIRMED_STATUSES = new HashSet<String>(Arrays.asList("SS", "HK", "KK"));

    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product product : GDSHelper.getProducts((Reservation)reservation)) {
            for (SegmentTariff st : product.getSegmentTariffs()) {
                for (Segment s : st.getSegments()) {
                    Map<DictionaryReference<SpecialServiceRequestDict>, MiscUtil.Pair<SsrInner, SsrInner>> ssrData = SabreSsrHelper.getSsrData(response, product, s);
                    for (Map.Entry<DictionaryReference<SpecialServiceRequestDict>, MiscUtil.Pair<SsrInner, SsrInner>> entry : ssrData.entrySet()) {
                        SpecialServiceRequest ssr = GDSHelper.findSsr((Segment)s, entry.getKey());
                        if (ssr == null) {
                            ssr = new SpecialServiceRequest();
                            ssr.setType(entry.getKey());
                            ssr.setRequestDate(new Date());
                            s.getSsrs().add(ssr);
                        }
                        ssr.setRequestFreeText(((SsrInner)entry.getValue().getFirst()).getFullText());
                        SsrInner ssrResponse = (SsrInner)entry.getValue().getSecond();
                        if (ssrResponse != null) {
                            String responseFreeText = ssrResponse.getFullText();
                            Matcher ssrFreeTextMatcher = SabreSsrHelper.SSR_FREE_TEXT_PATTERN.matcher(responseFreeText);
                            if (!ssrFreeTextMatcher.matches()) {
                                throw Xeption.forDeveloper((String)"ssr free text pattern mismatch: {0}", (Object[])new Object[]{responseFreeText});
                            }
                            if (CONFIRMED_STATUSES.contains(ssrResponse.getActionCode())) {
                                ssr.setStatus(SpecialServiceRequestStatus.CONFIRMED);
                            } else {
                                ssr.setStatus(SpecialServiceRequestStatus.REJECTED);
                            }
                            ssr.setResponseFreeText(responseFreeText);
                            continue;
                        }
                        ssr.setStatus(SpecialServiceRequestStatus.PENDING);
                    }
                }
            }
        }
    }
}

