/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tasks.airlineAlliances;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class K9LAStarResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        Map<Airline, AirlineAlliance> aaData = this.parse(response);
        HashSet<Airline> toSave = new HashSet<Airline>();
        for (Airline airline : DictionaryCache.get().getAll(Airline.class).values()) {
            AirlineAlliance newAlliance;
            AirlineAlliance oldAlliance = (AirlineAlliance)DictionaryCache.get().resolveReference(airline.getAlliance());
            UpdateResult updateResult = K9LAStarResponseParser.getUpdateResult(oldAlliance, newAlliance = aaData.get(airline));
            if (updateResult == UpdateResult.UNCHANGED) continue;
            airline.setAlliance((DictionaryReference)(newAlliance == null ? null : newAlliance.toReference()));
            toSave.add(airline);
        }
        for (Airline airline : toSave) {
            airline.setDataSource("SabreTask-airlineAlliances");
            DictionaryStorage.get().save((BaseDictionary)airline);
        }
    }

    private static UpdateResult getUpdateResult(AirlineAlliance oldAlliance, AirlineAlliance newAlliance) {
        if (oldAlliance == null) {
            if (newAlliance == null) {
                return UpdateResult.UNCHANGED;
            }
            return UpdateResult.ADDED;
        }
        if (newAlliance == null) {
            return UpdateResult.REMOVED;
        }
        if (oldAlliance.getCode().equals(newAlliance.getCode())) {
            return UpdateResult.UNCHANGED;
        }
        return UpdateResult.UPDATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Airline, AirlineAlliance> parse(String string) throws Exception {
        HashMap<Airline, AirlineAlliance> result = new HashMap<Airline, AirlineAlliance>();
        try (BufferedReader br = new BufferedReader(new StringReader(string));){
            String line;
            AirlineAlliance curAlliance = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("**  ")) {
                    String curAllianceCode = line.substring(4, 6);
                    curAlliance = (AirlineAlliance)DictionaryCache.get().findByCode(AirlineAlliance.class, curAllianceCode);
                    if (curAlliance != null) continue;
                    throw new Exception("unknown airline alliance code: " + curAllianceCode);
                }
                if (curAlliance != null) {
                    for (String airlineCode : line.split(" ")) {
                        Airline airline = (Airline)DictionaryCache.get().findByCode(Airline.class, airlineCode);
                        if (airline == null) {
                            throw new Exception("unknown airline code: " + airlineCode);
                        }
                        if (result.containsKey(airline)) {
                            throw new Exception(String.format("airline %s in multiple alliances: %s and %s", airline.getCode(), ((AirlineAlliance)result.get(airline)).getCode(), curAlliance));
                        }
                        result.put(airline, curAlliance);
                    }
                    continue;
                }
                this.log.warn("ignored line (no current alliance and line doesn't start with '**  '): " + line);
            }
        }
        return result;
    }

    private static enum UpdateResult {
        ADDED,
        REMOVED,
        UPDATED,
        UNCHANGED;

    }
}

