/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tasks.bspCommission;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.FixBspCommissionLongRunningTaskConfiguration;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class FixBspCommissionTask
extends BaseLongRunningTask<FixBspCommissionLongRunningTaskConfiguration> {
    private FixBspCommissionLongRunningTaskConfiguration configuration;

    public void configure(FixBspCommissionLongRunningTaskConfiguration configuration) throws Exception {
        this.configuration = configuration;
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"FIX_BSP_COMMISSION_TASK_DESCRIPTION", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
    }

    public void fromXML(Element elm) throws Exception {
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        this.log.info("started, issueDateStart={}, issueDateEnd={}", (Object)this.configuration.getIssueDateStart(), (Object)this.configuration.getIssueDateEnd());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getGdsNameSearchCriterionForProductIndex((GdsName)GdsName.SABRE));
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)ProductIndex.Property.issueDate.name(), (Object)this.configuration.getIssueDateStart(), (Object)this.configuration.getIssueDateEnd()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.bspCommissionRate.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.bspCommissionRate.name(), (Object)0));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.pcc.name(), null));
        query.getPreferredProperties().add("uid");
        Set refs = EntityStorage.get().search(ProductIndex.class, query).getData().stream().map(ProductIndex::getSource).collect(Collectors.toSet());
        this.log.info("got {} booking file references", (Object)refs.size());
        for (EntityReference ref : refs) {
            this.log.info("processing booking file {}", (Object)ref.getUid());
            if (Thread.currentThread().isInterrupted()) {
                this.log.error("interrupted");
                throw new InterruptedException();
            }
            try {
                LockUtil.lock((EntityReference)ref, () -> {
                    EntityContainer bfCtr = EntityStorage.get().resolve(ref);
                    boolean modified = false;
                    this.log.info("booking file {} step 1 -- set correct rate and value from WTDB", (Object)ref.getUid());
                    Map<EntityReference, List<Reservation>> groupedReservations = ((BookingFile)bfCtr.getEntity()).getReservations().stream().filter(r -> {
                        EntityReference onlineGdsAccount = r.getGdsNameInfo().getOnlineGdsAccount();
                        return onlineGdsAccount != null && SabreGdsAccount.class.equals((Object)onlineGdsAccount.getType());
                    }).collect(Collectors.groupingBy(reservation -> reservation.getGdsNameInfo().getOnlineGdsAccount()));
                    HashSet<Product> processedProducts = new HashSet<Product>();
                    for (Map.Entry<EntityReference, List<Reservation>> reservationsGroup : groupedReservations.entrySet()) {
                        List<Reservation> reservationsGroupValue = reservationsGroup.getValue();
                        String locators = reservationsGroupValue.stream().map(SabreHelper::getRecordLocator).collect(Collectors.joining(", "));
                        this.log.info("processing reservations {}", (Object)locators);
                        List products = reservationsGroupValue.stream().map(Reservation::getProducts).flatMap(Collection::stream).filter(bp -> bp instanceof Product).map(bp -> (Product)bp).filter(p -> p.getStatus() == ProductStatus.SELL).filter(p -> p.getPcc() != null).filter(p -> p.getSystemNumber() != null && p.getCarrierNumber() != null).filter(p -> p.getIssueDate() != null && !p.getIssueDate().before(this.configuration.getIssueDateStart()) && !p.getIssueDate().after(this.configuration.getIssueDateEnd())).filter(p -> p.getBspCommissionRate() != null && Double.compare(p.getBspCommissionRate(), 0.0) != 0).collect(Collectors.toList());
                        if (products.isEmpty()) {
                            this.log.warn("no relevant products found for step 1 in reservations {}", (Object)locators);
                            continue;
                        }
                        Map<String, List<Product>> groupedProducts = products.stream().collect(Collectors.groupingBy(Product::getPcc));
                        for (Map.Entry<String, List<Product>> productsGroup : groupedProducts.entrySet()) {
                            List<Product> productsGroupValue = productsGroup.getValue();
                            this.log.info("processing products {}", (Object)productsGroupValue.stream().map(p -> p.getCarrierNumber().concat(p.getSystemNumber())).collect(Collectors.joining(", ")));
                            HashMap<String, Object> ctx = new HashMap<String, Object>();
                            ctx.put(IBusMidofficeContextKeys.GDS_ACCOUNT.name(), EntityStorage.get().resolve(reservationsGroup.getKey()));
                            ctx.put(IBusGdsContextKeys.PRODUCTS.name(), productsGroupValue);
                            ctx.put(IBusGdsSabreContextKeys.CONTEXT_CHANGE_PCC.name(), productsGroup.getKey());
                            IntegrationBusFacade.get().processRouteSync("gds:sabre:fix-bsp-commission:fix-bsp-commission", ctx);
                            processedProducts.addAll(productsGroupValue);
                            modified = modified || (Boolean)ctx.get("modified") != false;
                            this.log.info("booking file {} modified is {}", (Object)ref.getUid(), (Object)modified);
                        }
                    }
                    this.log.info("booking file {} step 2 -- set correct value", (Object)ref.getUid());
                    List products = ((BookingFile)bfCtr.getEntity()).getReservations().stream().filter(r -> {
                        EntityReference onlineGdsAccount = r.getGdsNameInfo().getOnlineGdsAccount();
                        return onlineGdsAccount != null && SabreGdsAccount.class.equals((Object)onlineGdsAccount.getType());
                    }).map(Reservation::getProducts).flatMap(Collection::stream).filter(bp -> bp instanceof Product).map(bp -> (Product)bp).filter(p -> !processedProducts.contains(p)).filter(p -> "RUB".equals(p.getGdsCurrency())).filter(p -> AirProductHelper.getEquivalentFare((Product)p) != null).filter(p -> p.getIssueDate() != null && !p.getIssueDate().before(this.configuration.getIssueDateStart()) && !p.getIssueDate().after(this.configuration.getIssueDateEnd())).filter(p -> p.getBspCommissionRate() != null && Double.compare(p.getBspCommissionRate(), 0.0) != 0).filter(p -> p.getBspCommissionValue() != null && p.getBspCommissionValue().getValue() != null && p.getBspCommissionValue().getValue().scale() != 2).collect(Collectors.toList());
                    if (products.isEmpty()) {
                        this.log.info("no relevant products found for step 2 in booking file {}", (Object)ref.getUid());
                    }
                    modified = modified || !products.isEmpty();
                    for (Product product : products) {
                        BigDecimal oldValue = product.getBspCommissionValue().getValue();
                        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
                        BigDecimal bspCommissionValue = equivalentFare.multiply(BigDecimal.valueOf(product.getBspCommissionRate())).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                        product.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)bspCommissionValue, (String)product.getGdsCurrency()));
                        this.log.info("changed bsp commission value (step 2) for product {} from {} to {}", new Object[]{product.getUid(), oldValue, bspCommissionValue});
                    }
                    if (modified) {
                        bfCtr.getVersionInfo().setDataSource(MiscUtil.getSimpleClassName(FixBspCommissionTask.class));
                        EntityStorage.get().save(bfCtr, true);
                        this.log.info("saved modified booking file {}", (Object)ref.getUid());
                    } else {
                        this.log.warn("skipped unmodified booking file {}", (Object)ref.getUid());
                    }
                });
            }
            catch (Exception ex) {
                this.log.error("failed processing booking file {}", (Object)ref.getUid(), (Object)ex);
            }
        }
    }
}

