/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tasks.bspCommission;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WTDBAResponseParser
extends BaseProcessor {
    private static final Pattern P_COMM_PCT = Pattern.compile("COMM PCT:(?<value>[0-9]+(\\.[0-9]+)?)");

    public void process(MessageContext ctx) throws Exception {
        BigDecimal bspCommissionValue;
        double bspCommissionRate;
        BigDecimal oldValue;
        Double oldRate;
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
        String productNumber = product.getCarrierNumber().concat(product.getSystemNumber());
        Matcher mCommPct = P_COMM_PCT.matcher(response);
        if (mCommPct.find()) {
            oldRate = product.getBspCommissionRate();
            oldValue = product.getBspCommissionValue().getValue();
            bspCommissionRate = Double.parseDouble(mCommPct.group("value"));
            product.setBspCommissionRate(Double.valueOf(bspCommissionRate));
            BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)product);
            if (equivalentFare != null) {
                int scale = WTDBAResponseParser.getDecimalPlaces(product.getGdsCurrency(), 2);
                bspCommissionValue = equivalentFare.multiply(BigDecimal.valueOf(bspCommissionRate)).divide(BigDecimal.valueOf(100L), scale, RoundingMode.HALF_UP);
            } else {
                bspCommissionValue = BigDecimal.ZERO;
            }
        } else {
            this.log.error("COMM PCT not found for product {}", (Object)productNumber);
            throw Xeption.forDeveloper((String)"COMM PCT not found", (Object[])new Object[0]);
        }
        product.setBspCommissionValue(MoneyHelper.buildMoney((BigDecimal)bspCommissionValue, (String)product.getGdsCurrency()));
        ctx.putObject("modified", (Object)Boolean.TRUE);
        this.log.info("changed bsp commission rate (step 1) for product {} from {} to {}", new Object[]{productNumber, oldRate, bspCommissionRate});
        this.log.info("changed bsp commission value (step 1) for product {} from {} to {}", new Object[]{productNumber, oldValue, bspCommissionValue});
    }

    private static Integer getDecimalPlaces(String currencyCode, Integer defaultValue) {
        if ("RUB".equals(currencyCode)) {
            return 2;
        }
        CurrencyInfo curInfo = (CurrencyInfo)DictionaryCache.get().resolveReference((DictionaryReference)new CurrencyInfoReference(currencyCode));
        if (curInfo != null && curInfo.getIataDecimalPlaces() != null) {
            return curInfo.getIataDecimalPlaces();
        }
        return defaultValue;
    }
}

