/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tasks.classOfService;

import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.ClassOfServiceCode;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.SabreClassOfServiceSpellVariants;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ClassOfServiceTable;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.VendorCodesRS;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class VendorCodesRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        VendorCodesRS response = (VendorCodesRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        String dumpAirlineMapping = (String)ctx.getObject("debug.dump_airline_mapping");
        Date currentDate = new Date();
        Map map = DictionaryCache.get().getAll(SabreClassOfServiceSpellVariants.class);
        HashMap<MiscUtil.Pair, ClassOfService> data = new HashMap<MiscUtil.Pair, ClassOfService>();
        HashSet<String> missingAirlines = new HashSet<String>();
        HashSet<String> missingDescriptions = new HashSet<String>();
        for (VendorCodesRS.Table table : response.getTableList()) {
            for (VendorCodesRS.Table.Row row : table.getRowList()) {
                String classCode = ((VendorCodesRS.Table.Row.Column)row.getColumnList().get(0)).getText();
                String airlineCode = ((VendorCodesRS.Table.Row.Column)row.getColumnList().get(1)).getText();
                String description = ((VendorCodesRS.Table.Row.Column)row.getColumnList().get(2)).getText();
                if (dumpAirlineMapping != null && dumpAirlineMapping.equals(airlineCode)) {
                    this.log.info(classCode + '\t' + airlineCode + '\t' + description);
                }
                Airline airline = null;
                if (!StringUtils.isBlank((String)airlineCode) && (airline = DictHelper.findAirlineByAnyCode((String)airlineCode, (Date)currentDate)) == null) {
                    missingAirlines.add(airlineCode);
                    continue;
                }
                if (StringUtils.isBlank((String)classCode)) {
                    this.log.warn("No class code provided for airline " + airlineCode);
                    continue;
                }
                ClassOfService classOfService = null;
                EnumSet<ClassOfService> duplicateDescriptionClasses = null;
                for (SabreClassOfServiceSpellVariants var : map.values()) {
                    if (!var.getSpellVariants().contains(description)) continue;
                    if (classOfService == null) {
                        classOfService = var.getClassOfService();
                        continue;
                    }
                    if (duplicateDescriptionClasses == null) {
                        duplicateDescriptionClasses = EnumSet.of(classOfService, var.getClassOfService());
                        continue;
                    }
                    duplicateDescriptionClasses.add(var.getClassOfService());
                }
                if (classOfService == null) {
                    if (description == null) continue;
                    missingDescriptions.add(description);
                    continue;
                }
                if (duplicateDescriptionClasses != null) {
                    this.log.warn("Description " + description + " was found for more than one class: " + StringUtils.join(duplicateDescriptionClasses, (char)','));
                }
                ClassOfServiceCode code = new ClassOfServiceCode();
                AirlineReference airlineRef = airline == null ? null : airline.toReference();
                code.setAirline((DictionaryReference)airlineRef);
                code.setClassOfService(classOfService);
                code.setCode(classCode);
                data.put(new MiscUtil.Pair((Object)airlineRef, (Object)classCode), classOfService);
            }
        }
        ClassOfServiceTable.fillTable(data);
        if (!missingAirlines.isEmpty()) {
            this.log.warn("Missing airlines: " + StringUtils.join(missingAirlines, (char)','));
        }
        if (!missingDescriptions.isEmpty()) {
            this.log.warn("Missing class descriptions: " + StringUtils.join(missingDescriptions, (char)','));
        }
    }
}

