/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tasks.currencyRates;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreErrorsTranslatorHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.tasks.currencyRates.CurrencyRateSettings;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DCResponseParser
extends BaseProcessor {
    private static final Pattern RATE_LINE_PATTERN = Pattern.compile("RATE BSR.*");

    public void process(MessageContext ctx) throws Exception {
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        List updatedCurrencyRates = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.UPDATED_CURRENCY_RATES);
        Matcher m1 = RATE_LINE_PATTERN.matcher(response);
        if (!m1.find()) {
            SabreErrorsTranslatorHelper.parseError(response, ctx);
            throw Xeption.forDeveloper((String)("RATE_LINE_PATTERN not matched: " + response), (Object[])new Object[0]);
        }
        CurrencyRateSettings settings = (CurrencyRateSettings)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CURRENCY_RATE_SETTINGS);
        Pattern p2 = Pattern.compile("([0-9\\.]+)[ ]*" + settings.getBaseCurrencyCode());
        Matcher m2 = p2.matcher(m1.group());
        if (!m2.find()) {
            throw Xeption.forDeveloper((String)"rate pattern not matched", (Object[])new Object[0]);
        }
        BigDecimal rateValue = new BigDecimal(m2.group(1));
        String currency = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CURRENCY);
        CurrencyRate rate = BookingHelper.findCurrencyRate((String)settings.getBaseCurrencyCode(), (String)currency, (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, (TariffType)TariffType.REGULAR, null, null);
        if (rate == null || Double.compare(rate.getRate(), rateValue.doubleValue()) != 0) {
            rate = new CurrencyRate();
            rate.setBaseCurrency(settings.getBaseCurrencyCode());
            rate.setCurrency(currency);
            rate.setDate(new Date());
            rate.setRate(rateValue.doubleValue());
            rate.setType(CurrencyRateType.IATA);
            rate.setTariffType(TariffType.REGULAR);
            rate.setDataSource("SabreTask-currencyRates");
            DictionaryStorage.get().save((BaseDictionary)rate);
            updatedCurrencyRates.add(rate);
        }
    }
}

