/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tasks.fqtvAgreements;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FrequentTravellerAgreements;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PTStarResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        String part;
        String response = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        ArrayList<String> listAirlines = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^ [A-Z0-9]{2}\\-", 8);
        Matcher matcher = pattern.matcher(response);
        int i = -1;
        while (matcher.find()) {
            if (i != -1) {
                part = response.substring(i, matcher.start());
                listAirlines.add(part);
            }
            i = matcher.start();
        }
        part = response.substring(i);
        listAirlines.add(part);
        HashMap actualFtas = new HashMap();
        pattern = Pattern.compile("\\s+(?<rc>[A-Z0-9]{2})\\-.*\\s+.*(?<ocs>(\\s+.*)+)\\s+");
        for (String p : listAirlines) {
            ArrayList<FrequentTravellerAgreements> listFTAs = new ArrayList<FrequentTravellerAgreements>();
            matcher = pattern.matcher(p);
            if (matcher.matches()) {
                String[] ocs = matcher.group("ocs").trim().split("\\s+");
                if (ocs.length == 2 && ocs[0].equals("ALL") && ocs[1].equals("CARRIERS")) {
                    FrequentTravellerAgreements fta2 = new FrequentTravellerAgreements();
                    fta2.setReceivingCarrier(SabreHelper.resolveNativeCode(Airline.class, (String)matcher.group("rc")));
                    fta2.setAllCarriers(true);
                    listFTAs.add(fta2);
                } else {
                    for (String owningCarrier : ocs) {
                        FrequentTravellerAgreements fta3 = new FrequentTravellerAgreements();
                        fta3.setReceivingCarrier(SabreHelper.resolveNativeCode(Airline.class, (String)matcher.group("rc")));
                        if (owningCarrier.length() == 3) {
                            fta3.setSegmentSpecificAllowed(true);
                        }
                        fta3.setOwningCarrier(SabreHelper.resolveNativeCode(Airline.class, (String)owningCarrier.substring(0, 2)));
                        listFTAs.add(fta3);
                    }
                }
            }
            actualFtas.put(SabreHelper.resolveNativeCode(Airline.class, (String)matcher.group("rc")), listFTAs);
        }
        Map<DictionaryReference, List<FrequentTravellerAgreements>> currentFtas = DictionaryCache.get().getAll(FrequentTravellerAgreements.class).values().stream().collect(Collectors.groupingBy(fta -> fta.getReceivingCarrier()));
        HashSet<Object> airlines = new HashSet<Object>();
        airlines.addAll(actualFtas.keySet());
        airlines.addAll(currentFtas.keySet());
        ArrayList<FrequentTravellerAgreements> ftasToAdd = new ArrayList<FrequentTravellerAgreements>();
        ArrayList<FrequentTravellerAgreements> ftasToRemove = new ArrayList<FrequentTravellerAgreements>();
        for (DictionaryReference dictionaryReference : airlines) {
            if (actualFtas.containsKey(dictionaryReference)) {
                if (currentFtas.containsKey(dictionaryReference)) {
                    boolean found;
                    for (FrequentTravellerAgreements currentFta : currentFtas.get(dictionaryReference)) {
                        found = false;
                        for (FrequentTravellerAgreements actualFta : (List)actualFtas.get(dictionaryReference)) {
                            if (!MiscUtil.equals((Object)currentFta.getOwningCarrier(), (Object)actualFta.getOwningCarrier()) || currentFta.isSegmentSpecificAllowed() != actualFta.isSegmentSpecificAllowed() || currentFta.isAllCarriers() != actualFta.isAllCarriers()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ftasToRemove.add(currentFta);
                    }
                    for (FrequentTravellerAgreements actualFta : (List)actualFtas.get(dictionaryReference)) {
                        found = false;
                        for (FrequentTravellerAgreements currentFta : currentFtas.get(dictionaryReference)) {
                            if (!MiscUtil.equals((Object)currentFta.getOwningCarrier(), (Object)actualFta.getOwningCarrier()) || currentFta.isSegmentSpecificAllowed() != actualFta.isSegmentSpecificAllowed() || currentFta.isAllCarriers() != actualFta.isAllCarriers()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ftasToAdd.add(actualFta);
                    }
                    continue;
                }
                ftasToAdd.addAll((Collection)actualFtas.get(dictionaryReference));
                continue;
            }
            ftasToRemove.addAll((Collection)currentFtas.get(dictionaryReference));
        }
        for (FrequentTravellerAgreements frequentTravellerAgreements : ftasToAdd) {
            frequentTravellerAgreements.setDataSource("SabreTask-fqtvAgreements");
            DictionaryStorage.get().save((BaseDictionary)frequentTravellerAgreements);
        }
        for (FrequentTravellerAgreements frequentTravellerAgreements : ftasToRemove) {
            DictionaryStorage.get().delete((BaseDictionary)frequentTravellerAgreements);
        }
    }
}

