/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tasks.updateAircraftDict;

import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.sabre.webservices.sabrexml.EncodeDecodeRS;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EncodeDecodeRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EncodeDecodeRS response = (EncodeDecodeRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        if (response.getTextList() != null) {
            Aircraft aircraft = (Aircraft)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.AIRCRAFT);
            String[] fullName = ((String)response.getTextList().get(0)).split("\\s+", 2);
            String name = fullName.length > 1 ? fullName[1] : (String)response.getTextList().get(0);
            aircraft.getTranslations().put(Locale.ENGLISH, name);
            String seatsString = (String)response.getTextList().get(1);
            ArrayList<Integer> seatsList = new ArrayList<Integer>();
            Pattern pattern = Pattern.compile("[0-9]+");
            Matcher matcher = pattern.matcher(seatsString);
            while (matcher.find()) {
                seatsList.add(Integer.parseInt(matcher.group()));
            }
            if (seatsList.size() == 1) {
                aircraft.setSeats(((Integer)seatsList.get(0)).intValue());
                aircraft.setMaxSeats(((Integer)seatsList.get(0)).intValue());
            }
            if (seatsList.size() == 2) {
                aircraft.setSeats(((Integer)seatsList.get(0)).intValue());
                aircraft.setMaxSeats(((Integer)seatsList.get(1)).intValue());
            }
            aircraft.setDataSource("SabreTask-UpdateAircraftDict");
            DictionaryStorage.get().save((BaseDictionary)aircraft);
        }
    }
}

