/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.WCommandParameters;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.ticketReservation.AirTicketRQHelper;
import com.gridnine.xtrip.server.gds.sabre.ticketReservation.FOPQualifiersBasicFopAdapter;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.AirTicketRQ;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;

public class AirTicketRQBuilder
extends BaseProcessor {
    private static final FastDateFormat DF_SU_BSP_END = FastDateFormat.getInstance((String)"ddMMMyyyy", (Locale)Locale.ENGLISH);
    private static final List<String> CIS_COUNTRIES = Arrays.asList("XU", "RU", "UA", "KZ", "BY", "AZ", "UZ", "TM", "GE", "AM", "TJ", "KG", "MD");

    public void process(MessageContext ctx) {
        AirTicketRQ request = new AirTicketRQ();
        request.setVersion("2.14.0");
        request.setReturnHostCommand(Boolean.TRUE);
        WCommandParameters parameters = (WCommandParameters)ctx.getObject((Enum)IBusGdsSabreContextKeys.W_COMMAND_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Collection nameNumbersTicketingGroup = (Collection)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS_TICKETING_GROUP);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Product aProduct = (Product)GDSHelper.getProducts((Reservation)reservation).get(0);
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        AirTicketRQ.OptionalQualifiers oq = new AirTicketRQ.OptionalQualifiers();
        AirTicketRQ.OptionalQualifiers.PricingQualifiers pqs = new AirTicketRQ.OptionalQualifiers.PricingQualifiers();
        Map pqNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PQ_NUMBERS);
        HashMap pqns = new HashMap();
        for (Product product : GDSHelper.getProducts((Reservation)reservation)) {
            if (!nameNumbersTicketingGroup.contains(product.getGdsId())) continue;
            String pqNumber = (String)pqNumbers.get(SabreHelper.getNativeCode((DictionaryReference)product.getPassengerType()));
            if (!pqns.containsKey(pqNumber)) {
                pqns.put(pqNumber, new HashSet());
            }
            ((Collection)pqns.get(pqNumber)).add(product.getGdsId());
        }
        for (Map.Entry entry : pqns.entrySet()) {
            AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote pq = new AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote();
            AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote.Record record = new AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote.Record();
            record.setNumber(new BigInteger((String)entry.getKey()));
            pq.getRecordList().add(record);
            for (String nameNumber : (Collection)entry.getValue()) {
                AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote.NameSelect ns = new AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote.NameSelect();
                ns.setNameNumber(new BigDecimal(nameNumber));
                pq.getNameSelectList().add(ns);
            }
            pqs.getPriceQuoteList().add(pq);
        }
        request.setNumResponses(BigInteger.valueOf(99L));
        oq.setPricingQualifiers(pqs);
        AirTicketRQ.OptionalQualifiers.MiscQualifiers mq = new AirTicketRQ.OptionalQualifiers.MiscQualifiers();
        mq.flagDateOfBirthPresent(true);
        AirTicketRQ.OptionalQualifiers.MiscQualifiers.Ticket ticket = new AirTicketRQ.OptionalQualifiers.MiscQualifiers.Ticket();
        ticket.setType("ETR");
        mq.setTicket(ticket);
        if (SabreHelper.isSuOnBsp((Product)aProduct) && this.isPassportInEndorsementNeeded(ctx)) {
            String nameNumber = (String)nameNumbersTicketingGroup.iterator().next();
            for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
                if (!MiscUtil.equals((Object)prod.getGdsId(), (Object)nameNumber)) continue;
                String string = SabreHelper.buildPassportTypeSu((PassportType)prod.getTraveller().getPassport().getType()) + prod.getTraveller().getPassport().getNumber() + "/DOB" + DF_SU_BSP_END.format(prod.getTraveller().getPassport().getBirthday()).toUpperCase();
                AirTicketRQ.OptionalQualifiers.MiscQualifiers.Endorsement end = new AirTicketRQ.OptionalQualifiers.MiscQualifiers.Endorsement();
                end.setText(string);
                mq.setEndorsement(end);
            }
        }
        oq.setMiscQualifiers(mq);
        if (parameters == null || !parameters.isOmitFop()) {
            AirTicketRQ.OptionalQualifiers.FOPQualifiers fq = new AirTicketRQ.OptionalQualifiers.FOPQualifiers();
            AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP basicFOP = new AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP();
            FOPQualifiersBasicFopAdapterImpl fopAdapter = new FOPQualifiersBasicFopAdapterImpl(basicFOP);
            AirTicketRQHelper.fillFopInformation(ctx, reservation, aProduct, fop, gdsParameters, fopAdapter);
            fq.setBasicFOP(basicFOP);
            oq.setFOPQualifiers1(fq);
        }
        request.setOptionalQualifiers(oq);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"AirTicketLLSRQ");
    }

    private boolean isPassportInEndorsementNeeded(MessageContext ctx) {
        return !CIS_COUNTRIES.contains(SabreServerHelper.getCountry(ctx));
    }

    private static class FOPQualifiersBasicFopAdapterImpl
    implements FOPQualifiersBasicFopAdapter<AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP.CCInfo> {
        final AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP basicFOP;

        public FOPQualifiersBasicFopAdapterImpl(AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP basicFOP) {
            this.basicFOP = basicFOP;
        }

        @Override
        public void setType(String type) {
            this.basicFOP.setType(type);
        }

        @Override
        public void setPaymentCardManualApprovalCode(String code) {
            AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP.CCInfo info = new AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP.CCInfo();
            info.setPaymentCardManualApprovalCode(code);
            this.basicFOP.setCCInfo1(info);
        }

        @Override
        public void setCCInfo(String paymentCardCode, BigInteger cardNumber, String expirationDate) {
            AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP.CCInfo info = new AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP.CCInfo();
            info.setPaymentCardCode(paymentCardCode);
            info.setPaymentCardNumber(cardNumber);
            info.setPaymentCardExpireDate(expirationDate);
            this.basicFOP.setCCInfo1(info);
        }

        @Override
        public AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP.CCInfo getCCInfo() {
            return this.basicFOP.getCCInfo1();
        }
    }
}

