/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation;

import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.sabre.ticketReservation.FOPQualifiersBasicFopAdapter;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirTicketRQHelper {
    private static final Logger log = LoggerFactory.getLogger(AirTicketRQHelper.class);

    /*
     * Enabled aggressive block sorting
     */
    public static void fillFopInformation(MessageContext ctx, Reservation reservation, Product aProduct, Fop fop, GDSParameters gdsParameters, FOPQualifiersBasicFopAdapter basicFopAdapter) {
        String paymentApprovalCode = reservation.getAdditionalInfo().getPaymentApprovalCode();
        if (!StringUtils.isBlank((String)paymentApprovalCode)) {
            basicFopAdapter.setPaymentCardManualApprovalCode(paymentApprovalCode);
        } else if ("S7".equals(SabreHelper.getNativeCode((DictionaryReference)aProduct.getCarrier())) && !StringUtils.isBlank((String)aProduct.getTripartiteContractDetails().getContractCode())) {
            basicFopAdapter.setType("INVOICE*" + aProduct.getTripartiteContractDetails().getContractCode());
        } else if (fop != null && fop.getType() != null) {
            switch (fop.getType()) {
                case CASH: {
                    basicFopAdapter.setType("CA");
                    break;
                }
                case CREDIT_CARD: {
                    AirlineCard acceptableCard;
                    CardVendor vendor;
                    Card card = fop.getCard();
                    if (card == null) {
                        basicFopAdapter.setType("CK");
                        break;
                    }
                    String cardVendorName = card.getVendor().name();
                    Airline airline = (Airline)DictionaryCache.get().resolveReference(aProduct.getCarrier());
                    Iterator iterator = airline.getAcceptableCards().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        throw Xeption.forDeveloper((String)"Sabre card type code is not set for airline: {0}, card type: {1}", (Object[])new Object[]{airline.getCode(), cardVendorName});
                    } while (!(vendor = (acceptableCard = (AirlineCard)iterator.next()).getVendor()).name().equals(cardVendorName));
                    String sabreCardType = acceptableCard.getCode();
                    String cardNumber = card.getNumber();
                    Date cardExp = card.getExpiration();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
                    String cardExpStr = df.format(cardExp);
                    MaskSensitiveTraceDataHelper.addMaskedPaymentCardNumberValue((MessageContext)ctx, (String)cardNumber);
                    MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)cardExpStr, (String)"####");
                    basicFopAdapter.setCCInfo(sabreCardType, new BigInteger(cardNumber), cardExpStr);
                    break;
                }
                case INVOICE: {
                    if (SabreHelper.isTchBlankOwner((EntityReference)aProduct.getBlankOwnerRef())) {
                        basicFopAdapter.setType("INVAGT");
                        break;
                    }
                    basicFopAdapter.setType("CK");
                    break;
                }
                default: {
                    basicFopAdapter.setType("CA");
                    log.warn("No case for FOP " + fop.getType().name() + " found, please add this FOP to WCommandBuilder");
                    break;
                }
            }
        } else {
            basicFopAdapter.setType("CA");
        }
        if (StringUtils.isBlank((String)gdsParameters.getFopReplacementCode())) return;
        if (basicFopAdapter.getCCInfo() != null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0442\u0438\u043f \u043e\u043f\u043b\u0430\u0442\u044b '{0}', \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0440\u0430\u0432\u0438\u043b \u0432 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436, \u043d\u0435 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d, \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u0430\u043d\u043d\u044b\u0435 \u043a\u0440\u0435\u0434\u0438\u0442\u043d\u043e\u0439 \u043a\u0430\u0440\u0442\u044b", (Object[])new Object[]{gdsParameters.getFopReplacementCode()}));
            return;
        }
        basicFopAdapter.setType(gdsParameters.getFopReplacementCode());
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0442\u0438\u043f \u043e\u043f\u043b\u0430\u0442\u044b '{0}', \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0440\u0430\u0432\u0438\u043b \u0432 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436", (Object[])new Object[]{gdsParameters.getFopReplacementCode()}));
    }
}

