/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class BuildNameNumberTicketingGroupsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Set actual;
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Product aProduct = (Product)GDSHelper.getProducts((Reservation)reservation).get(0);
        HashSet<Set<String>> result = new HashSet<Set<String>>();
        ctx.putObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS_TICKETING_GROUPS, result);
        if (SabreHelper.isSuOnBsp((Product)aProduct)) {
            for (Product prod2 : GDSHelper.getProducts((Reservation)reservation)) {
                result.add(Collections.singleton(prod2.getGdsId()));
            }
            return;
        }
        ImmutableListMultimap pqGroups = Multimaps.index(GetReservationHelper.getValidPriceQuotes(response), pqd -> pqd.getTransactionInfo().getInputEntry());
        ImmutableListMultimap productsByPassengerType = Multimaps.index((Iterable)GDSHelper.getProducts((Reservation)reservation), prod -> SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType()));
        for (Collection pqGroup : pqGroups.asMap().values()) {
            HashSet<String> nameNumbers = new HashSet<String>();
            for (PriceQuoteDetails pqd2 : pqGroup) {
                for (Product prod3 : productsByPassengerType.get((Object)GetReservationHelper.deteminePassengerTypeCode(pqd2))) {
                    nameNumbers.add(prod3.getGdsId());
                }
            }
            result.add(nameNumbers);
        }
        Set expected = GDSHelper.getProducts((Reservation)reservation).stream().map(Product::getGdsId).collect(Collectors.toSet());
        if (!expected.equals(actual = result.stream().flatMap(Collection::stream).collect(Collectors.toSet()))) {
            throw Xeption.forEndUser((String)"\u041f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 . \u0414\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0430/\u043a \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0432\u044f\u0437\u0430\u0442\u044c\u0441\u044f \u0441 \u043a\u043e\u043b-\u0446\u0435\u043d\u0442\u0440\u043e\u043c", (Object[])new Object[0]);
        }
    }
}

