/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AccountingLinePNRB;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class GetReservationUpdateProductsAfterTicketingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        HashMap<String, Product> ticketProductsByNumber = new HashMap<String, Product>();
        HashMap<String, Product> mcoProductsByGdsId = new HashMap<String, Product>();
        ArrayList<Product> productsToUpdateStatus = new ArrayList<Product>();
        for (Product prod : AirProductHelper.getProducts((Reservation)reservation)) {
            if (prod.getProductCategory() == ProductCategory.AIR) {
                ticketProductsByNumber.put(prod.getGdsId(), prod);
            }
            if (prod.getProductCategory() != ProductCategory.MCO) continue;
            mcoProductsByGdsId.put(prod.getGdsId(), prod);
        }
        HashSet<String> emdDocumentNumbers = new HashSet<String>();
        if (!mcoProductsByGdsId.isEmpty()) {
            for (PassengerPNRB passenger : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
                if (passenger.getAncillaryServices() == null || passenger.getAncillaryServices().getAncillaryServiceList() == null) continue;
                for (AncillaryServicesPNRB ancillaryService : passenger.getAncillaryServices().getAncillaryServiceList()) {
                    Product mco;
                    if (("HK".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode()) || "KK".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode())) && ancillaryService.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice().equals(BigDecimal.ZERO) || (mco = (Product)mcoProductsByGdsId.get(ancillaryService.getId())) == null || mco.getStatus() != ProductStatus.BOOKING) continue;
                    mco.setSystemNumber(ancillaryService.getAncillaryServicesDataGroupPNRB().getSegment().getEMDNumber().substring(3));
                    emdDocumentNumbers.add(mco.getSystemNumber());
                    productsToUpdateStatus.add(mco);
                }
            }
        }
        for (AccountingLinePNRB info : response.getReservation().getAccountingLines().getAccountingLineList()) {
            if (info.getPassengerName() == null || emdDocumentNumbers.contains(info.getDocumentNumber())) continue;
            Product prod = (Product)ticketProductsByNumber.get(GetReservationHelper.getNameNumberFromAccountingLine(info));
            prod.setSystemNumber(info.getDocumentNumber());
            prod.setConjCount(Integer.parseInt(info.getNumberOfConjunctedDocuments()) - 1);
            productsToUpdateStatus.add(prod);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS, productsToUpdateStatus);
    }
}

