/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FormalIdentificationType;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;

public class PassengerDetailsAddFoidsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.GET_RESERVATION_RS);
        FormalIdentificationType foidTypeToSend = (FormalIdentificationType)ctx.getObject((Enum)IBusGdsContextKeys.FOID_TYPE_TO_SEND);
        for (Product product : GDSHelper.getProducts((Reservation)reservation)) {
            if (!SabreServerHelper.getFixedNameIdsWithNoFoidsAdded(response).contains(product.getGdsId())) continue;
            if (foidTypeToSend != null) {
                PassengerDetailsHelper.addSsr("FOID", null, product.getGdsId(), this.buildFoidText(product, foidTypeToSend), request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
            }
            if (!SabreHelper.isTchBlankOwner((EntityReference)product.getBlankOwnerRef())) continue;
            PassengerDetailsHelper.addSsr("FOID", null, product.getGdsId(), this.buildTchFoidText(product.getTraveller().getPassport()), request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
    }

    private String buildFoidText(Product product, FormalIdentificationType type) {
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case CREDIT_CARD_NUMBER: {
                sb.append("CC");
                sb.append(SabreHelper.getNativeCode((DictionaryReference)product.getCarrier()));
                sb.append(((ProductFop)AirProductHelper.getClientContractRelation((Product)product).getFops().get(0)).getCard().getNumber());
                break;
            }
            case FREQUENT_FLYER_CARD_NUMBER: {
                sb.append("FF");
                sb.append(SabreHelper.getNativeCode((DictionaryReference)product.getCarrier()));
                sb.append(((BookingAirlineBonusCard)product.getTraveller().getAirlineBonusCards().get(0)).getNumber());
                break;
            }
            case PASSPORT_NUMBER: {
                Passport passport = product.getTraveller().getPassport();
                if (passport.getType() == PassportType.BIRTHDAY_NOTIFICATION || passport.getType() == PassportType.IDENTITYCARD) {
                    sb.append("ID");
                } else {
                    sb.append("PP");
                }
                sb.append(SabreHelper.getNativeCode((DictionaryReference)product.getTraveller().getPassport().getCitizenship()));
                sb.append(product.getTraveller().getPassport().getNumber());
                break;
            }
            case PNR_NUMBER: {
                sb.append("CN");
                sb.append(SabreHelper.getRecordLocator((Reservation)product.getReservation()));
                break;
            }
            case TICKET_NUMBER: {
                sb.append("TN");
                sb.append(product.getSystemNumber());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return sb.toString();
    }

    private String buildTchFoidText(Passport passport) {
        StringBuilder sb = new StringBuilder();
        sb.append("ID");
        sb.append(PassengerDetailsAddFoidsProcessor.getTchCode(passport.getType()));
        sb.append(passport.getNumber());
        return sb.toString();
    }

    private static String getTchCode(PassportType passportType) {
        switch (passportType) {
            case INTERNAL: {
                return "PS";
            }
            case FOREIGN: {
                return "PSP";
            }
            case DIPLOMATIC: {
                return "DP";
            }
            case BIRTHDAY_NOTIFICATION: {
                return "SR";
            }
            case CERTIFICATEOFRELEASE: {
                return "SPO";
            }
            case SEAMANSID: {
                return "PM";
            }
            case MILITARYID: {
                return "VB";
            }
            case PASSPORT: {
                return "NP";
            }
            case INTERIMCERTIFICATE: {
                return "SPU";
            }
            case MILITARYCERTIFICATE: {
                return "UDL";
            }
            case BACKTOUSSRCERTIFICATE: {
                return "CVV";
            }
            case SERVICE_PASSPORT: {
                return "SP";
            }
            case RESIDENCEPERMIT: {
                return "VV";
            }
            case FOREIGN_NATIONAL_PASSPORT: {
                return "ZA";
            }
        }
        throw Xeption.forDeveloper((String)"unexpected passport type {0}", (Object[])new Object[]{passportType});
    }
}

