/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddVatRemarksProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
            String vatInfo = SabreServerHelper.buildEndorsementVatInfo(prod);
            if (StringUtils.isBlank((String)vatInfo)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("X*-INCL VAT ");
            PassengerDetailsAddVatRemarksProcessor.appendVat(sb, prod, false);
            PassengerDetailsAddVatRemarksProcessor.addRemark(request, PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.INVOICE, sb.toString());
            sb = new StringBuilder();
            sb.append("XVAT*");
            PassengerDetailsAddVatRemarksProcessor.appendVat(sb, prod, true);
            PassengerDetailsAddVatRemarksProcessor.addRemark(request, PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.INVOICE, sb.toString());
            sb = new StringBuilder();
            sb.append("VAT*");
            PassengerDetailsAddVatRemarksProcessor.appendVat(sb, prod, true);
            PassengerDetailsAddVatRemarksProcessor.addRemark(request, PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.HISTORICAL, sb.toString());
        }
    }

    private static void appendVat(StringBuilder sb, Product prod, boolean withTicketNumber) {
        if (withTicketNumber) {
            sb.append(prod.getCarrierNumber());
            sb.append(prod.getSystemNumber());
            sb.append("*");
        }
        sb.append(prod.getTotalVendorEquivalentVatAmount());
        sb.append(prod.getGdsCurrency());
        sb.append("-");
        sb.append(prod.getGdsId());
    }

    private static void addRemark(PassengerDetailsRQ request, PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type type, String text) {
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(type);
        remark.setText(text);
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }
}

