/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation;

import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WTDBOBOutputParser
extends BaseProcessor {
    private static final Pattern P_VALUE = Pattern.compile("OB FEE\\:.*\\s+([0-9\\.]+)\\s+");

    public void process(MessageContext ctx) throws Exception {
        Matcher m;
        String output = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        if (!output.contains("NONE APPLIED") && (m = P_VALUE.matcher(output)).find()) {
            Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
            Money amount = new Money();
            amount.setValue(new BigDecimal(m.group(1)));
            amount.setCurrency(product.getGdsCurrency());
            OBFee obFee = new OBFee();
            obFee.setAmount(amount);
            obFee.setDescription("CREDIT CARD CHARGE");
            product.getObFees().add(obFee);
            AirProductHelper.updateFops((Product)product);
        }
    }
}

