/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation.ctn;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.CTNParameters;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.sabre.webservices.sabrexml.AirTicketRQ;
import java.util.ArrayList;

public class CtnTicketingRequestBuilder
extends BaseProcessor {
    private static String buildModifier(AirTicketRQ airTicketRQ) {
        AirTicketRQ.OptionalQualifiers.FOPQualifiers fq;
        ArrayList<String> qualifiers = new ArrayList<String>();
        AirTicketRQ.OptionalQualifiers oq = airTicketRQ.getOptionalQualifiers();
        for (AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote pq : oq.getPricingQualifiers().getPriceQuoteList()) {
            qualifiers.add(String.format("PQ%sN%s", ((AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote.Record)pq.getRecordList().get(0)).getNumber().toString(), ((AirTicketRQ.OptionalQualifiers.PricingQualifiers.PriceQuote.NameSelect)pq.getNameSelectList().get(0)).getNameNumber().toString()));
        }
        AirTicketRQ.OptionalQualifiers.MiscQualifiers mq = oq.getMiscQualifiers();
        if (mq.ifDateOfBirthPresent()) {
            qualifiers.add("DOB");
        }
        qualifiers.add(mq.getTicket().getType());
        if (mq.getEndorsement() != null) {
            qualifiers.add("ED" + mq.getEndorsement().getText());
        }
        if ((fq = oq.getFOPQualifiers1()) != null) {
            if (fq.getBasicFOP().getType() != null) {
                qualifiers.add("F" + fq.getBasicFOP().getType());
            } else {
                AirTicketRQ.OptionalQualifiers.FOPQualifiers.BasicFOP.CCInfo cci = fq.getBasicFOP().getCCInfo1();
                if (cci.getPaymentCardManualApprovalCode() != null) {
                    qualifiers.add("F*Z" + cci.getPaymentCardManualApprovalCode());
                } else {
                    qualifiers.add(String.format("F*%s%s/%s%s", cci.getPaymentCardCode(), cci.getPaymentCardNumber(), cci.getPaymentCardExpireDate().substring(5), cci.getPaymentCardExpireDate().substring(2, 4)));
                }
            }
        }
        return String.join((CharSequence)"\u00a5", qualifiers).substring(2);
    }

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        AirTicketRQ airTicketRQ = (AirTicketRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        String ctnToken = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CTN_TOKEN);
        CTNParameters ctnParameters = ((SabreGdsAccount)gdsAccountCtr.getEntity()).getCtnParameters();
        HttpRequest request = new HttpRequest();
        request.setRequestMethod(RequestMethod.GET);
        request.setUrl(ctnParameters.getUrl() + "ticketing");
        request.getQueryParameters().put((Object)"modifier", (Object)new String[]{CtnTicketingRequestBuilder.buildModifier(airTicketRQ)});
        request.getQueryParameters().put((Object)"rule", (Object)new String[]{ctnParameters.getRuleApiKey()});
        request.getQueryParameters().put((Object)"office", (Object)new String[]{ctnParameters.getOfficeApiKey()});
        request.getQueryParameters().put((Object)"command", (Object)new String[]{"issue"});
        request.getQueryParameters().put((Object)"locator", (Object)new String[]{SabreHelper.getRecordLocator((Reservation)reservation)});
        request.getQueryParameters().put((Object)"token", (Object)new String[]{ctnToken});
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)request);
    }
}

