/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation.ticketMco;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.ticketReservation.AirTicketRQHelper;
import com.gridnine.xtrip.server.gds.sabre.ticketReservation.FOPQualifiersBasicFopAdapter;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.air.ticket.v13.AirTicketRQ;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MCOTicketBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List productsToTicket = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCTS);
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Map<Product, AncillaryServicesPNRB> mcoProduct2AncillaryService = MCOTicketBuilder.getMcoProduct2AncillaryService(response, productsToTicket);
        AirTicketRQ request = new AirTicketRQ();
        request.setVersion("1.3.0");
        request.setItinerary(SabreHelper.getRecordLocator((Reservation)reservation));
        for (Product product : productsToTicket) {
            Commission productCommission;
            AncillaryServicesPNRB as = mcoProduct2AncillaryService.get(product);
            AirTicketRQ.Ticketing ticketing = new AirTicketRQ.Ticketing();
            AirTicketRQ.Ticketing.MiscQualifiers mq = new AirTicketRQ.Ticketing.MiscQualifiers();
            AirTicketRQ.Ticketing.MiscQualifiers.Ticket ticket = new AirTicketRQ.Ticketing.MiscQualifiers.Ticket();
            ticket.setType("EMD");
            mq.setTicket(ticket);
            AirTicketRQ.Ticketing.MiscQualifiers.AirExtras airExtras = new AirTicketRQ.Ticketing.MiscQualifiers.AirExtras();
            airExtras.setNumber(new BigInteger(as.getSequenceNumber()));
            mq.getAirExtraList().add(airExtras);
            if ("Y".equals(as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getCommisionIndicator()) && (productCommission = SabreHelper.getTotalVendorCommissionForSabre((Product)product)) != null) {
                BigDecimal value;
                AirTicketRQ.Ticketing.MiscQualifiers.Commission commission = new AirTicketRQ.Ticketing.MiscQualifiers.Commission();
                if (productCommission.getRate() != null) {
                    value = BigDecimal.valueOf(productCommission.getRate());
                    value = value.setScale(2, RoundingMode.HALF_UP);
                    commission.setPercent(value);
                } else {
                    value = productCommission.getEquivalentAmount();
                    value = value.setScale(AirPriceHelper.getIataDecimalPlacesForCurrency(DictHelper.getCurrencyInfoByAnyCode((String)product.getGdsCurrency())), RoundingMode.HALF_UP);
                    commission.setAmount(value);
                }
                mq.setCommission(commission);
            }
            ticketing.setMiscQualifiers(mq);
            AirTicketRQ.Ticketing.FOPQualifiers fopQualifiers = new AirTicketRQ.Ticketing.FOPQualifiers();
            AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP bFop = new AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP();
            FOPQualifiersBasicFopAdapterImpl fopAdapter = new FOPQualifiersBasicFopAdapterImpl(bFop);
            AirTicketRQHelper.fillFopInformation(ctx, reservation, product, fop, gdsParameters, fopAdapter);
            fopQualifiers.setBasicFOP(bFop);
            ticketing.setFOPQualifiers1(fopQualifiers);
            request.getTicketingList().add(ticketing);
        }
        AirTicketRQ.PostProcessing postProcessing = new AirTicketRQ.PostProcessing();
        AirTicketRQ.PostProcessing.EndTransaction endTransaction = new AirTicketRQ.PostProcessing.EndTransaction();
        AirTicketRQ.PostProcessing.EndTransaction.Source source = new AirTicketRQ.PostProcessing.EndTransaction.Source();
        source.setReceivedFrom(((SabreGdsAccount)accountCtr.getEntity()).getTransactionExecutor());
        endTransaction.setSource(source);
        postProcessing.setEndTransaction(endTransaction);
        AirTicketRQ.PostProcessing.GhostTicketCheck ghostTicketCheck = new AirTicketRQ.PostProcessing.GhostTicketCheck();
        ghostTicketCheck.setNumAttempts(BigInteger.valueOf(5L));
        ghostTicketCheck.setWaitInterval(BigInteger.valueOf(3000L));
        postProcessing.setGhostTicketCheck(ghostTicketCheck);
        request.setPostProcessing(postProcessing);
        AirTicketRQ.AccountingLines accountingLines = new AirTicketRQ.AccountingLines();
        accountingLines.setNone(Boolean.TRUE);
        request.setAccountingLines(accountingLines);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"AirTicketRQ");
    }

    private static Map<Product, AncillaryServicesPNRB> getMcoProduct2AncillaryService(GetReservationRSType response, List<Product> productsToTicket) {
        HashMap<Product, AncillaryServicesPNRB> mcoProduct2AncillaryService = new HashMap<Product, AncillaryServicesPNRB>();
        for (PassengerPNRB passenger : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
            if (passenger.getAncillaryServices() == null || passenger.getAncillaryServices().getAncillaryServiceList() == null) continue;
            for (AncillaryServicesPNRB ancillaryService : passenger.getAncillaryServices().getAncillaryServiceList()) {
                if (("HK".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode()) || "KK".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode())) && ancillaryService.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice().equals(BigDecimal.ZERO)) continue;
                Product mcoProduct = MCOTicketBuilder.findMcoProductByAncillaryServiceId(productsToTicket, ancillaryService);
                mcoProduct2AncillaryService.put(mcoProduct, ancillaryService);
            }
        }
        return mcoProduct2AncillaryService;
    }

    private static Product findMcoProductByAncillaryServiceId(List<Product> mcoProducts, AncillaryServicesPNRB ancillaryService) {
        Product mcoProduct = mcoProducts.stream().filter(mco -> mco.getGdsId().equals(ancillaryService.getId())).findFirst().orElse(null);
        if (mcoProduct == null) {
            throw Xeption.forDeveloper((String)"mco with gdsId = {0} is not found", (Object[])new Object[]{ancillaryService.getId()});
        }
        return mcoProduct;
    }

    private static class FOPQualifiersBasicFopAdapterImpl
    implements FOPQualifiersBasicFopAdapter<AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo> {
        private final AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP basicFOP;

        FOPQualifiersBasicFopAdapterImpl(AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP basicFOP) {
            this.basicFOP = basicFOP;
        }

        @Override
        public void setType(String type) {
            this.basicFOP.setType(type);
        }

        @Override
        public void setPaymentCardManualApprovalCode(String code) {
            AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo info = new AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo();
            info.setPaymentCardManualApprovalCode(code);
            this.basicFOP.setCCInfo1(info);
        }

        @Override
        public void setCCInfo(String paymentCardCode, BigInteger cardNumber, String expirationDate) {
            AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo info = new AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo();
            info.setPaymentCardCode(paymentCardCode);
            info.setPaymentCardNumber(cardNumber);
            info.setPaymentCardExpireDate(expirationDate);
            this.basicFOP.setCCInfo1(info);
        }

        @Override
        public AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo getCCInfo() {
            return null;
        }
    }
}

