/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservation.ticketMco;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TicketMCOReservationProvider
extends BaseRoutingKeyProvider {
    private final List<String> STATUS_CONFIRMED = Arrays.asList("HD", "KD");
    private final List<MCOCategory> MCO_CATEGORIES_SUPPORTED = Arrays.asList(MCOCategory.SEAT_RESERVATION, MCOCategory.EXCESS_LUGGAGE);

    public String getRoutingKey(MessageContext ctx) {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List productToTicket = GDSHelper.getProducts((Reservation)reservation, (ProductCategory[])new ProductCategory[]{ProductCategory.MCO}).stream().filter(prod -> prod.getStatus() == ProductStatus.BOOKING && this.MCO_CATEGORIES_SUPPORTED.contains(prod.getMcoCategory()) && prod.getMcoReservationRequestStatus() == MCOReservationRequestStatus.CONFIRMED).collect(Collectors.toList());
        if (productToTicket.isEmpty()) {
            return String.valueOf(false);
        }
        Map productGdsIdMap = productToTicket.stream().collect(Collectors.toMap(Product::getGdsId, Function.identity()));
        for (PassengerPNRB passenger : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
            if (passenger.getAncillaryServices() == null || passenger.getAncillaryServices().getAncillaryServiceList() == null) continue;
            for (AncillaryServicesPNRB ancillaryService : passenger.getAncillaryServices().getAncillaryServiceList()) {
                if (!this.STATUS_CONFIRMED.contains(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode()) || ancillaryService.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice().equals(BigDecimal.ZERO)) continue;
                Product mco = (Product)productGdsIdMap.get(ancillaryService.getId());
                if (mco == null) {
                    return String.valueOf(false);
                }
                if (mco.getMcoCategory() == MCOCategory.SEAT_RESERVATION) {
                    if (!TextUtil.isBlank((String)ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getBookingIndicator())) {
                        return String.valueOf(false);
                    }
                    if (!"S".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getSegmentIndicator())) {
                        return String.valueOf(false);
                    }
                }
                if (mco.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE && !TextUtil.isBlank((String)ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getBookingIndicator()) && !"01".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getBookingIndicator())) {
                    return String.valueOf(false);
                }
                if ("2".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getEMDType())) continue;
                return String.valueOf(false);
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.PRODUCTS, productToTicket);
        return String.valueOf(true);
    }
}

