/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservationNew;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.gds.sabre.model.WCommandParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.airPrice.AirPriceHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.endTransaction.EndTransactionRQParameters;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.gds.sabre.ticketReservation.AirTicketRQHelper;
import com.gridnine.xtrip.server.gds.sabre.ticketReservation.FOPQualifiersBasicFopAdapter;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.services.sp.air.ticket.v13.AirTicketRQ;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.FastDateFormat;

public class EnhancedAirTicketRQBuilder
extends BaseProcessor {
    private static final List<String> CIS_COUNTRIES = Arrays.asList("XU", "RU", "UA", "KZ", "BY", "AZ", "UZ", "TM", "GE", "AM", "TJ", "KG", "MD");
    private static final FastDateFormat DF_SU_BSP_END = FastDateFormat.getInstance((String)"ddMMMyyyy", (Locale)Locale.ENGLISH);
    private static final List<String> STATUS_CONFIRMED = Arrays.asList("HD", "KD");
    private static final List<MCOCategory> MCO_CATEGORIES_SUPPORTED = Arrays.asList(MCOCategory.SEAT_RESERVATION, MCOCategory.EXCESS_LUGGAGE);

    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        EndTransactionRQParameters etParameters = (EndTransactionRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.END_TRANSACTION_RQ_PARAMETERS);
        WCommandParameters wParameters = (WCommandParameters)ctx.getObject((Enum)IBusGdsSabreContextKeys.W_COMMAND_PARAMETERS);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        Product aProduct = (Product)GDSHelper.getProducts((Reservation)reservation).get(0);
        Map pqNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PQ_NUMBERS);
        boolean passportInEndorsementNeeded = this.isPassportInEndorsementNeeded(ctx);
        boolean isSuOnBsp = SabreHelper.isSuOnBsp((Product)aProduct);
        AirTicketRQ rq = new AirTicketRQ();
        rq.setVersion("1.3.0");
        rq.setHaltOnInvalidMCT(Boolean.valueOf(true));
        rq.setItinerary(SabreHelper.getRecordLocator((Reservation)reservation));
        AirTicketRQ.AccountingLines accountingLines = new AirTicketRQ.AccountingLines();
        accountingLines.setNone(Boolean.valueOf(true));
        rq.setAccountingLines(accountingLines);
        for (Collection collection : EnhancedAirTicketRQBuilder.buildNameNumbersTicketingGroups(response, reservation, isSuOnBsp)) {
            AirTicketRQ.Ticketing ticketing = new AirTicketRQ.Ticketing();
            ticketing.setPricingQualifiers(EnhancedAirTicketRQBuilder.buildPricingQualifiers(reservation, collection, pqNumbers));
            ticketing.setMiscQualifiers(EnhancedAirTicketRQBuilder.buildMiscQualifiers(isSuOnBsp, passportInEndorsementNeeded, collection, reservation));
            if (wParameters == null || !wParameters.isOmitFop()) {
                AirTicketRQ.Ticketing.FOPQualifiers fq = new AirTicketRQ.Ticketing.FOPQualifiers();
                AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP basicFOP = new AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP();
                FOPQualifiersBasicFopAdapterImpl fopAdapter = new FOPQualifiersBasicFopAdapterImpl(basicFOP);
                AirTicketRQHelper.fillFopInformation(ctx, reservation, aProduct, fop, gdsParameters, fopAdapter);
                fq.setBasicFOP(basicFOP);
                ticketing.setFOPQualifiers1(fq);
            }
            rq.getTicketingList().add(ticketing);
        }
        List<Product> mcoProducts = EnhancedAirTicketRQBuilder.getMCOProducts(reservation, response);
        Map<Product, AncillaryServicesPNRB> map = EnhancedAirTicketRQBuilder.getMcoProduct2AncillaryService(response, mcoProducts);
        for (Product product : mcoProducts) {
            Commission productCommission;
            AncillaryServicesPNRB as = map.get(product);
            AirTicketRQ.Ticketing ticketing = new AirTicketRQ.Ticketing();
            AirTicketRQ.Ticketing.MiscQualifiers mq = new AirTicketRQ.Ticketing.MiscQualifiers();
            AirTicketRQ.Ticketing.MiscQualifiers.Ticket ticket = new AirTicketRQ.Ticketing.MiscQualifiers.Ticket();
            ticket.setType("EMD");
            mq.setTicket(ticket);
            AirTicketRQ.Ticketing.MiscQualifiers.AirExtras airExtras = new AirTicketRQ.Ticketing.MiscQualifiers.AirExtras();
            airExtras.setNumber(new BigInteger(as.getSequenceNumber()));
            mq.getAirExtraList().add(airExtras);
            if ("Y".equals(as.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getCommisionIndicator()) && (productCommission = SabreHelper.getTotalVendorCommissionForSabre((Product)product)) != null) {
                BigDecimal value;
                AirTicketRQ.Ticketing.MiscQualifiers.Commission commission = new AirTicketRQ.Ticketing.MiscQualifiers.Commission();
                if (productCommission.getRate() != null) {
                    value = BigDecimal.valueOf(productCommission.getRate());
                    value = value.setScale(2, RoundingMode.HALF_UP);
                    commission.setPercent(value);
                } else {
                    value = productCommission.getEquivalentAmount();
                    value = value.setScale(AirPriceHelper.getIataDecimalPlacesForCurrency(DictHelper.getCurrencyInfoByAnyCode((String)product.getGdsCurrency())), RoundingMode.HALF_UP);
                    commission.setAmount(value);
                }
                mq.setCommission(commission);
            }
            ticketing.setMiscQualifiers(mq);
            AirTicketRQ.Ticketing.FOPQualifiers fopQualifiers = new AirTicketRQ.Ticketing.FOPQualifiers();
            AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP bFop = new AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP();
            FOPQualifiersBasicFopAdapterImpl fopAdapter = new FOPQualifiersBasicFopAdapterImpl(bFop);
            AirTicketRQHelper.fillFopInformation(ctx, reservation, product, fop, gdsParameters, fopAdapter);
            fopQualifiers.setBasicFOP(bFop);
            ticketing.setFOPQualifiers1(fopQualifiers);
            rq.getTicketingList().add(ticketing);
        }
        AirTicketRQ.PostProcessing postProcessing = new AirTicketRQ.PostProcessing();
        postProcessing.setAcceptNegotiatedFare(Boolean.valueOf(false));
        postProcessing.setAcceptPriceChanges(Boolean.valueOf(false));
        postProcessing.setActionOnBackDatePrice(AirTicketRQ.PostProcessing.ActionOnBackDatePrice.Q);
        postProcessing.setActionOnPQExpired(AirTicketRQ.PostProcessing.ActionOnPQExpired.Q);
        AirTicketRQ.PostProcessing.EndTransaction endTransaction = new AirTicketRQ.PostProcessing.EndTransaction();
        if (etParameters.getMode() != EndTransactionRQParameters.Mode.END_ONLY) {
            AirTicketRQ.PostProcessing.EndTransaction.Source source = new AirTicketRQ.PostProcessing.EndTransaction.Source();
            source.setReceivedFrom(((SabreGdsAccount)gdsAccountCtr.getEntity()).getTransactionExecutor());
            endTransaction.setSource(source);
        }
        if (etParameters.isEmail()) {
            AirTicketRQ.PostProcessing.EndTransaction.Email email = new AirTicketRQ.PostProcessing.EndTransaction.Email();
            email.setInd(true);
            AirTicketRQ.PostProcessing.EndTransaction.Email.ETicket eTicket = new AirTicketRQ.PostProcessing.EndTransaction.Email.ETicket();
            eTicket.setInd(true);
            if (etParameters.isPdf()) {
                AirTicketRQ.PostProcessing.EndTransaction.Email.ETicket.PDF pdf = new AirTicketRQ.PostProcessing.EndTransaction.Email.ETicket.PDF();
                pdf.setInd(true);
                eTicket.setPDF1(pdf);
            }
            email.setETicket(eTicket);
            if (etParameters.isN00()) {
                AirTicketRQ.PostProcessing.EndTransaction.Email.PersonName personName = new AirTicketRQ.PostProcessing.EndTransaction.Email.PersonName();
                personName.setNameNumber("0.0");
                email.setPersonName(personName);
            }
            endTransaction.setEmail(email);
        }
        postProcessing.setEndTransaction(endTransaction);
        rq.setPostProcessing(postProcessing);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)rq);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"AirTicketRQ");
    }

    private boolean isPassportInEndorsementNeeded(MessageContext ctx) {
        return !CIS_COUNTRIES.contains(SabreServerHelper.getCountry(ctx));
    }

    private static Collection<Collection<String>> buildNameNumbersTicketingGroups(GetReservationRSType response, Reservation reservation, boolean isSuOnBsp) {
        Set actual;
        HashSet<Collection<String>> result = new HashSet<Collection<String>>();
        if (isSuOnBsp) {
            for (Product prod2 : GDSHelper.getProducts((Reservation)reservation)) {
                result.add(Collections.singleton(prod2.getGdsId()));
            }
            return result;
        }
        ImmutableListMultimap pqGroups = Multimaps.index(GetReservationHelper.getValidPriceQuotes(response), pqd -> pqd.getTransactionInfo().getInputEntry());
        ImmutableListMultimap productsByPassengerType = Multimaps.index((Iterable)GDSHelper.getProducts((Reservation)reservation), prod -> SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType()));
        for (Collection pqGroup : pqGroups.asMap().values()) {
            HashSet<String> nameNumbers = new HashSet<String>();
            for (PriceQuoteDetails pqd2 : pqGroup) {
                for (Product prod3 : productsByPassengerType.get((Object)GetReservationHelper.deteminePassengerTypeCode(pqd2))) {
                    nameNumbers.add(prod3.getGdsId());
                }
            }
            result.add(nameNumbers);
        }
        Set expected = GDSHelper.getProducts((Reservation)reservation).stream().map(Product::getGdsId).collect(Collectors.toSet());
        if (!expected.equals(actual = result.stream().flatMap(Collection::stream).collect(Collectors.toSet()))) {
            throw Xeption.forEndUser((String)"\u041f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 . \u0414\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0437\u0430\u043a\u0430\u0437\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0430/\u043a \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0432\u044f\u0437\u0430\u0442\u044c\u0441\u044f \u0441 \u043a\u043e\u043b-\u0446\u0435\u043d\u0442\u0440\u043e\u043c", (Object[])new Object[0]);
        }
        return result;
    }

    private static AirTicketRQ.Ticketing.PricingQualifiers buildPricingQualifiers(Reservation reservation, Collection<String> nameNumbersTicketingGroup, Map<String, String> pqNumbers) {
        AirTicketRQ.Ticketing.PricingQualifiers pqs = new AirTicketRQ.Ticketing.PricingQualifiers();
        HashMap pqns = new HashMap();
        for (Product product : GDSHelper.getProducts((Reservation)reservation)) {
            if (!nameNumbersTicketingGroup.contains(product.getGdsId())) continue;
            String pqNumber = pqNumbers.get(SabreHelper.getNativeCode((DictionaryReference)product.getPassengerType()));
            if (!pqns.containsKey(pqNumber)) {
                pqns.put(pqNumber, new HashSet());
            }
            ((Collection)pqns.get(pqNumber)).add(product.getGdsId());
        }
        for (Map.Entry entry : pqns.entrySet()) {
            AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote pq = new AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote();
            AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote.Record record = new AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote.Record();
            record.setNumber(new BigInteger((String)entry.getKey()));
            pq.getRecordList().add(record);
            for (String nameNumber : (Collection)entry.getValue()) {
                AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote.NameSelect ns = new AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote.NameSelect();
                ns.setNameNumber(new BigDecimal(nameNumber));
                pq.getNameSelectList().add(ns);
            }
            pqs.getPriceQuoteList().add(pq);
        }
        return pqs;
    }

    private static AirTicketRQ.Ticketing.MiscQualifiers buildMiscQualifiers(boolean isSuOnBsp, boolean passportInEndorsementNeeded, Collection<String> nameNumbersTicketingGroup, Reservation reservation) {
        AirTicketRQ.Ticketing.MiscQualifiers mq = new AirTicketRQ.Ticketing.MiscQualifiers();
        mq.setDateOfBirth("");
        AirTicketRQ.Ticketing.MiscQualifiers.Ticket ticket = new AirTicketRQ.Ticketing.MiscQualifiers.Ticket();
        ticket.setType("ETR");
        mq.setTicket(ticket);
        if (isSuOnBsp && passportInEndorsementNeeded) {
            String nameNumber = nameNumbersTicketingGroup.iterator().next();
            for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
                if (!MiscUtil.equals((Object)prod.getGdsId(), (Object)nameNumber)) continue;
                String text = SabreHelper.buildPassportTypeSu((PassportType)prod.getTraveller().getPassport().getType()) + prod.getTraveller().getPassport().getNumber() + "/DOB" + DF_SU_BSP_END.format(prod.getTraveller().getPassport().getBirthday()).toUpperCase();
                AirTicketRQ.Ticketing.MiscQualifiers.Endorsement end = new AirTicketRQ.Ticketing.MiscQualifiers.Endorsement();
                end.setText(text);
                mq.setEndorsement(end);
            }
        }
        return mq;
    }

    public static List<Product> getMCOProducts(Reservation reservation, GetReservationRSType response) {
        List<Product> productsToTicket = GDSHelper.getProducts((Reservation)reservation, (ProductCategory[])new ProductCategory[]{ProductCategory.MCO}).stream().filter(prod -> prod.getStatus() == ProductStatus.BOOKING && MCO_CATEGORIES_SUPPORTED.contains(prod.getMcoCategory()) && prod.getMcoReservationRequestStatus() == MCOReservationRequestStatus.CONFIRMED).collect(Collectors.toList());
        if (productsToTicket.isEmpty()) {
            return Collections.emptyList();
        }
        Map productGdsIdMap = productsToTicket.stream().collect(Collectors.toMap(Product::getGdsId, Function.identity()));
        for (PassengerPNRB passenger : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
            if (passenger.getAncillaryServices() == null || passenger.getAncillaryServices().getAncillaryServiceList() == null) continue;
            for (AncillaryServicesPNRB ancillaryService : passenger.getAncillaryServices().getAncillaryServiceList()) {
                if (!STATUS_CONFIRMED.contains(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode()) || ancillaryService.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice().equals(BigDecimal.ZERO)) continue;
                Product mco = (Product)productGdsIdMap.get(ancillaryService.getId());
                if (mco == null) {
                    return Collections.emptyList();
                }
                if (mco.getMcoCategory() == MCOCategory.SEAT_RESERVATION) {
                    if (!TextUtil.isBlank((String)ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getBookingIndicator())) {
                        return Collections.emptyList();
                    }
                    if (!"S".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getSegmentIndicator())) {
                        return Collections.emptyList();
                    }
                }
                if (mco.getMcoCategory() == MCOCategory.EXCESS_LUGGAGE && !TextUtil.isBlank((String)ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getBookingIndicator()) && !"01".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getBookingIndicator())) {
                    return Collections.emptyList();
                }
                if ("2".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getBasicAncillaryServicesDataGroupPNRB().getEMDType())) continue;
                return Collections.emptyList();
            }
        }
        return productsToTicket;
    }

    private static Map<Product, AncillaryServicesPNRB> getMcoProduct2AncillaryService(GetReservationRSType response, List<Product> productsToTicket) {
        HashMap<Product, AncillaryServicesPNRB> mcoProduct2AncillaryService = new HashMap<Product, AncillaryServicesPNRB>();
        for (PassengerPNRB passenger : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
            if (passenger.getAncillaryServices() == null || passenger.getAncillaryServices().getAncillaryServiceList() == null) continue;
            for (AncillaryServicesPNRB ancillaryService : passenger.getAncillaryServices().getAncillaryServiceList()) {
                if (("HK".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode()) || "KK".equals(ancillaryService.getAncillaryServicesDataGroupPNRB().getActionCode())) && ancillaryService.getAncillaryServicesDataGroupPNRB().getOptionalAncillaryServicesInformationDataGroupPNRB().getTotalTTLPrice().getPrice().equals(BigDecimal.ZERO)) continue;
                Product mcoProduct = EnhancedAirTicketRQBuilder.findMcoProductByAncillaryServiceId(productsToTicket, ancillaryService);
                mcoProduct2AncillaryService.put(mcoProduct, ancillaryService);
            }
        }
        return mcoProduct2AncillaryService;
    }

    private static Product findMcoProductByAncillaryServiceId(List<Product> mcoProducts, AncillaryServicesPNRB ancillaryService) {
        Product mcoProduct = mcoProducts.stream().filter(mco -> mco.getGdsId().equals(ancillaryService.getId())).findFirst().orElse(null);
        if (mcoProduct == null) {
            throw Xeption.forDeveloper((String)"mco with gdsId = {0} is not found", (Object[])new Object[]{ancillaryService.getId()});
        }
        return mcoProduct;
    }

    private static class FOPQualifiersBasicFopAdapterImpl
    implements FOPQualifiersBasicFopAdapter<AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo> {
        final AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP basicFOP;

        public FOPQualifiersBasicFopAdapterImpl(AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP basicFOP) {
            this.basicFOP = basicFOP;
        }

        @Override
        public void setType(String type) {
            this.basicFOP.setType(type);
        }

        @Override
        public void setPaymentCardManualApprovalCode(String code) {
            AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo info = new AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo();
            info.setPaymentCardManualApprovalCode(code);
            this.basicFOP.setCCInfo1(info);
        }

        @Override
        public void setCCInfo(String paymentCardCode, BigInteger cardNumber, String expirationDate) {
            AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo info = new AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo();
            info.setPaymentCardCode(paymentCardCode);
            info.setPaymentCardNumber(cardNumber);
            info.setPaymentCardExpireDate(expirationDate);
            this.basicFOP.setCCInfo1(info);
        }

        @Override
        public AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo getCCInfo() {
            return this.basicFOP.getCCInfo1();
        }
    }
}

