/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.ticketReservationNew.ctn;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.CTNParameters;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import com.sabre.services.sp.air.ticket.v13.AirTicketRQ;
import java.util.ArrayList;

public class CtnTicketingRequestBuilder
extends BaseProcessor {
    private static String buildModifier(AirTicketRQ.Ticketing ticketing) {
        AirTicketRQ.Ticketing.FOPQualifiers fq;
        ArrayList<String> qualifiers = new ArrayList<String>();
        for (AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote pq : ticketing.getPricingQualifiers().getPriceQuoteList()) {
            qualifiers.add(String.format("PQ%sN%s", ((AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote.Record)pq.getRecordList().get(0)).getNumber().toString(), ((AirTicketRQ.Ticketing.PricingQualifiers.PriceQuote.NameSelect)pq.getNameSelectList().get(0)).getNameNumber().toString()));
        }
        AirTicketRQ.Ticketing.MiscQualifiers mq = ticketing.getMiscQualifiers();
        if (mq.getDateOfBirth() != null) {
            qualifiers.add("DOB");
        }
        qualifiers.add(mq.getTicket().getType());
        if (mq.getEndorsement() != null) {
            qualifiers.add("ED" + mq.getEndorsement().getText());
        }
        if ((fq = ticketing.getFOPQualifiers1()) != null) {
            if (fq.getBasicFOP().getType() != null) {
                qualifiers.add("F" + fq.getBasicFOP().getType());
            } else {
                AirTicketRQ.Ticketing.FOPQualifiers.BasicFOP.CCInfo cci = fq.getBasicFOP().getCCInfo1();
                if (cci.getPaymentCardManualApprovalCode() != null) {
                    qualifiers.add("F*Z" + cci.getPaymentCardManualApprovalCode());
                } else {
                    qualifiers.add(String.format("F*%s%s/%s%s", cci.getPaymentCardCode(), cci.getPaymentCardNumber(), cci.getPaymentCardExpireDate().substring(5), cci.getPaymentCardExpireDate().substring(2, 4)));
                }
            }
        }
        return String.join((CharSequence)"\u00a5", qualifiers).substring(2);
    }

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        AirTicketRQ.Ticketing ticketing = (AirTicketRQ.Ticketing)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.ENHANCED_AIR_TICKET_RQ_TICKETING);
        String ctnToken = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CTN_TOKEN);
        CTNParameters ctnParameters = ((SabreGdsAccount)gdsAccountCtr.getEntity()).getCtnParameters();
        HttpRequest request = new HttpRequest();
        request.setRequestMethod(RequestMethod.GET);
        request.setUrl(ctnParameters.getUrl() + "ticketing");
        request.getQueryParameters().put((Object)"modifier", (Object)new String[]{CtnTicketingRequestBuilder.buildModifier(ticketing)});
        request.getQueryParameters().put((Object)"rule", (Object)new String[]{ctnParameters.getRuleApiKey()});
        request.getQueryParameters().put((Object)"office", (Object)new String[]{ctnParameters.getOfficeApiKey()});
        request.getQueryParameters().put((Object)"command", (Object)new String[]{"issue"});
        request.getQueryParameters().put((Object)"locator", (Object)new String[]{SabreHelper.getRecordLocator((Reservation)reservation)});
        request.getQueryParameters().put((Object)"token", (Object)new String[]{ctnToken});
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)request);
    }
}

