/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.tjr;

import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.tjr.LocationRecordSettings;
import com.gridnine.xtrip.common.gds.sabre.tjr.TjrSettings;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WTAOutputParser
extends BaseProcessor {
    private static final Pattern P_PSGR_TYPE = Pattern.compile("^PSGR TYPE[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_YOU_HAVE_ACCESS_TO_THE_FOLLOWING_LOCATIONS_RECORDS = Pattern.compile("^YOU HAVE ACCESS TO THE FOLLOWING LOCATIONS RECORDS -[ ]*\n([A-Z0-9]{4}-B?C?[ \n]*)+", 8);
    private static final Pattern P_SINGLE_LOCATION_RECORD_SETTINGS = Pattern.compile("([A-Z0-9]{4})-(B?C?)[ \n]+");
    private static final Pattern P_AUTOMATIC_SEGMENT_ARRANGE = Pattern.compile("^AUTOMATIC SEGMENT ARRANGE[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_JOINT_VENTURE = Pattern.compile("^JOINT VENTURE[ ]*-.*$", 8);
    private static final Pattern P_LOR_CITY = Pattern.compile("^LOR CITY[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_TIME_ADJ = Pattern.compile("^TIME ADJ/[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_TIME_ZONE = Pattern.compile("^TIME ZONE[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_MULTI_CURRENCY = Pattern.compile("^MULTI/CURRENCY[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_AUTO_VAL = Pattern.compile("^AUTO VAL[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_AUTOMATIC_ELECTRONIC_TICKETING = Pattern.compile("^AUTOMATIC ELECTRONIC TICKETING[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_CTY_STA = Pattern.compile("^CTY/STA[ ]*-[ ]*(.*)$", 8);
    private static final Pattern P_COUNTRY = Pattern.compile("^COUNTRY[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_TICKETING_DEFAULT_CURRENCY = Pattern.compile("^TICKETING DEFAULT CURRENCY[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_OPTIONS = Pattern.compile("^OPTIONS[ ]*-[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_PQR = Pattern.compile("^PQR[ ]*([^ ]+)[ ]*$", 8);
    private static final Pattern P_PQR_REFUND_EXCHANGE = Pattern.compile("^PQR[ ]*[^ ]+[ ]*\n[ ]+REFUND / EXCHANGE[ ]*([^ ]+)[ ]*$", 8);
    private static Pattern P_SINGLE_CARRIER = Pattern.compile("([A-Z0-9]{2})[ \n]");

    public void process(MessageContext ctx) throws Exception {
        TjrSettings tjrSettings = (TjrSettings)ctx.getObject((Enum)IBusGdsSabreContextKeys.TJR_SETTINGS);
        if (tjrSettings == null) {
            tjrSettings = new TjrSettings();
            ctx.putObject((Enum)IBusGdsSabreContextKeys.TJR_SETTINGS, (Object)tjrSettings);
        }
        String output = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        tjrSettings.setPsgrType(SabreHelper.parseSingleValue((String)output, (Pattern)P_PSGR_TYPE));
        Matcher m = P_YOU_HAVE_ACCESS_TO_THE_FOLLOWING_LOCATIONS_RECORDS.matcher(output);
        if (m.find()) {
            String section = m.group(0);
            Matcher mSingle = P_SINGLE_LOCATION_RECORD_SETTINGS.matcher(section);
            while (mSingle.find()) {
                LocationRecordSettings lrs = new LocationRecordSettings();
                lrs.setPcc(mSingle.group(1));
                lrs.setLevels(mSingle.group(2));
                tjrSettings.getYouHaveAccessToTheFollowingLocationsRecords().add(lrs);
            }
        }
        tjrSettings.setAutomaticSegmentArrange(SabreHelper.parseSingleValue((String)output, (Pattern)P_AUTOMATIC_SEGMENT_ARRANGE));
        tjrSettings.setHasJointVenture(P_JOINT_VENTURE.matcher(output).find());
        tjrSettings.setLorCity(SabreHelper.parseSingleValue((String)output, (Pattern)P_LOR_CITY));
        tjrSettings.setTimeAdj(SabreHelper.parseSingleValue((String)output, (Pattern)P_TIME_ADJ));
        tjrSettings.setTimeZone(SabreHelper.parseSingleValue((String)output, (Pattern)P_TIME_ZONE));
        tjrSettings.setMultiCurrency(SabreHelper.parseSingleValue((String)output, (Pattern)P_MULTI_CURRENCY));
        tjrSettings.getCarriers().addAll(WTAOutputParser.parseCarriers(output, "CARRIERS"));
        tjrSettings.getEtrCarriers().addAll(WTAOutputParser.parseCarriers(output, "ETR CARRIERS"));
        tjrSettings.getTatCarriers().addAll(WTAOutputParser.parseCarriers(output, "TAT CARRIERS"));
        tjrSettings.getTchCarriers().addAll(WTAOutputParser.parseCarriers(output, "TCH CARRIERS"));
        tjrSettings.setAutoVal(SabreHelper.parseSingleValue((String)output, (Pattern)P_AUTO_VAL));
        tjrSettings.setAutomaticElectronicTicketing(SabreHelper.parseSingleValue((String)output, (Pattern)P_AUTOMATIC_ELECTRONIC_TICKETING));
        String ctySta = SabreHelper.parseSingleValue((String)output, (Pattern)P_CTY_STA);
        if (ctySta != null) {
            ctySta = ctySta.trim();
        }
        tjrSettings.setCtySta(ctySta);
        tjrSettings.setCountry(SabreHelper.parseSingleValue((String)output, (Pattern)P_COUNTRY));
        tjrSettings.setTicketingDefaultCurrency(SabreHelper.parseSingleValue((String)output, (Pattern)P_TICKETING_DEFAULT_CURRENCY));
        tjrSettings.setOptions(SabreHelper.parseSingleValue((String)output, (Pattern)P_OPTIONS));
        tjrSettings.setPqr(SabreHelper.parseSingleValue((String)output, (Pattern)P_PQR));
        tjrSettings.setPqrRefundExchange(SabreHelper.parseSingleValue((String)output, (Pattern)P_PQR_REFUND_EXCHANGE));
    }

    private static List<String> parseCarriers(String output, String sectionName) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile("^" + sectionName + "[ ]*-[ ]*\n([A-Z0-9]{2}[ \n]+)+", 8);
        Matcher m = p.matcher(output);
        if (m.find()) {
            String section = m.group(0);
            Matcher mSingleCarrier = P_SINGLE_CARRIER.matcher(section);
            while (mSingleCarrier.find()) {
                result.add(mSingleCarrier.group(1));
            }
        }
        return result;
    }
}

