/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.token;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.SabreToken;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.token.TokenNotFoundException;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;

public class GetSessionFromTokenProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        EntityContainer tokenCtr = EntityStorage.get().resolve(new EntityReference("token-" + accountCtr.getUid(), SabreToken.class, null), (EntityStorageLoadParameters)new EntityStorageLoadParameters().context("irrelevance-tolerant-query", (Object)Boolean.TRUE));
        if (tokenCtr == null) {
            throw new TokenNotFoundException();
        }
        SabreSession result = new SabreSession();
        result.setBinarySecurityToken(((SabreToken)tokenCtr.getEntity()).getBinarySecurityToken());
        result.setConversationId(((SabreToken)tokenCtr.getEntity()).getConversationId());
        result.setEndpointUrl(((SabreGdsAccount)accountCtr.getEntity()).getAddress());
        String ipcc = ((SabreGdsAccount)accountCtr.getEntity()).getPrimaryPCC();
        result.setIpcc(ipcc);
        result.setPcc(ipcc);
        result.setLastModified(new Date());
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION, (Object)result);
    }
}

