/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.updateMcoReservationRequestStatus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.SabreServerHelper;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AncillaryServicesPNRB;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.PassengerPNRB;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class UpdateMcoReservationRequestStatusProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List mcoProducts = GDSHelper.getProducts((Reservation)reservation, (ProductCategory[])new ProductCategory[]{ProductCategory.MCO});
        Map productGdsIdMap = mcoProducts.stream().collect(Collectors.toMap(Product::getGdsId, Function.identity()));
        for (PassengerPNRB passenger : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getPassengers().getPassengerList()) {
            for (AncillaryServicesPNRB ancillary : passenger.getAncillaryServices().getAncillaryServiceList()) {
                Product mco = (Product)productGdsIdMap.get(ancillary.getId());
                if (mco == null) continue;
                mco.setMcoReservationRequestStatus(SabreServerHelper.actionCode2MCOReservationRequestStatus(ancillary.getAncillaryServicesDataGroupPNRB().getActionCode()));
                if (mco.getMcoReservationRequestStatus() != MCOReservationRequestStatus.CONFIRMED || mco.getMcoCategory() != MCOCategory.SEAT_RESERVATION) continue;
                ((Segment)((SegmentTariff)mco.getSegmentTariffs().get(0)).getSegments().get(0)).setSeatNo(ancillary.getAncillaryServicesDataGroupPNRB().getPdcSeat());
            }
        }
    }
}

