/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.updateRemarks;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.OperationTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkTypePNRB;
import com.sabre.webservices.pnrbuilder.v119.RemarkUpdatePNRB;
import com.sabre.webservices.pnrbuilder.v119.RequestEnumerationType;
import com.sabre.webservices.pnrbuilder.v119.RequestType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateItemType;
import com.sabre.webservices.pnrbuilder.v119.ReservationUpdateListType;
import com.sabre.webservices.pnrbuilder.v119.ReturnOptions;
import com.sabre.webservices.pnrbuilder.v119.UpdateReservationRQ;
import java.util.ArrayList;
import java.util.Collection;

public class UpdateRemarksRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Collection createRemarks = (Collection)ctx.getObject((Enum)IBusGdsSabreContextKeys.REMARKS);
        Collection updateRemarks = (Collection)ctx.getObject((Enum)IBusGdsSabreContextKeys.UPDATE_REMARKS);
        Collection deleteRemarks = (Collection)ctx.getObject((Enum)IBusGdsSabreContextKeys.DELETE_REMARKS);
        if (!(createRemarks != null && !createRemarks.isEmpty() || updateRemarks != null && !updateRemarks.isEmpty() || deleteRemarks != null && !deleteRemarks.isEmpty())) {
            throw Xeption.forDeveloper((String)"No remarks to update", (Object[])new Object[0]);
        }
        UpdateReservationRQ request = (UpdateReservationRQ)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        if (request == null) {
            request = new UpdateReservationRQ();
            request.setVersion("1.19.11");
            RequestType requestType = new RequestType();
            ReturnOptions returnOptions = new ReturnOptions();
            returnOptions.setViewName("Full");
            returnOptions.setRetrievePNR(Boolean.valueOf(true));
            request.setReturnOptions(returnOptions);
            requestType.setRequestEnumerationType(RequestEnumerationType.STATEFUL);
            request.setRequestType(requestType);
            request.setReservationUpdateList(new ReservationUpdateListType());
            request.getReservationUpdateList().setChoice(new ReservationUpdateListType.Choice());
            request.getReservationUpdateList().getChoice().setReservationUpdateItemList(new ArrayList());
        }
        int idNewRemark = response.getReservation().getRemarks() != null && response.getReservation().getRemarks().getRemarkList() != null ? response.getReservation().getRemarks().getRemarkList().stream().map(el -> Integer.parseInt(el.getId())).max(Integer::compareTo).orElse(0) : 0;
        ReservationUpdateItemType item = new ReservationUpdateItemType();
        item.setUpdateId(Integer.toString(request.getReservationUpdateList().getChoice().getReservationUpdateItemList().size() + 1));
        ArrayList<RemarkUpdatePNRB> list = new ArrayList<RemarkUpdatePNRB>();
        if (createRemarks != null && !createRemarks.isEmpty()) {
            for (Remark remark : createRemarks) {
                list.add(this.createRemark(remark, ++idNewRemark, OperationTypePNRB.C));
            }
        }
        if (updateRemarks != null && !updateRemarks.isEmpty()) {
            for (Remark remark : updateRemarks) {
                list.add(this.createRemark(remark, this.getRemarkId(remark.getRph(), response), OperationTypePNRB.U));
            }
        }
        if (deleteRemarks != null && !deleteRemarks.isEmpty()) {
            for (Remark remark : deleteRemarks) {
                list.add(this.createRemark(remark, this.getRemarkId(remark.getRph(), response), OperationTypePNRB.D));
            }
        }
        item.setRemarkUpdateList(list);
        request.getReservationUpdateList().getChoice().getReservationUpdateItemList().add(item);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"UpdateReservationRQ");
    }

    private RemarkUpdatePNRB createRemark(Remark remark, int id, OperationTypePNRB operationType) {
        RemarkUpdatePNRB result = new RemarkUpdatePNRB();
        result.setId(String.valueOf(id));
        result.setOp(operationType);
        if (remark.getText() != null) {
            result.setRemarkText(remark.getText().replaceAll("@", "//").replaceAll("_", ".UN."));
        }
        result.setCode(remark.getCode());
        if (remark.getType() != null) {
            result.setType(RemarkTypePNRB.valueOf((String)remark.getType().getPnrbCode()));
        }
        return result;
    }

    private int getRemarkId(String rph, GetReservationRSType response) {
        return response.getReservation().getRemarks().getRemarkList().stream().filter(r -> r.getIndex().intValue() == Integer.parseInt(rph)).map(r -> Integer.parseInt(r.getId())).findFirst().get();
    }
}

