/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.voidReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.ETicketNumberType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GetRPHsToVoidProcessor
extends BaseProcessor {
    private boolean voidMco;

    public void configure(Map<String, String> parameters) {
        this.voidMco = Boolean.parseBoolean(parameters.get("voidMco"));
    }

    public void process(MessageContext ctx) throws Exception {
        Set ticketNumbers;
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        if (this.voidMco) {
            List mco = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
            ticketNumbers = SabreHelper.getTicketNumbersInTicketingLinesFormat((List)mco);
        } else {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            ticketNumbers = SabreHelper.getTicketNumbersInTicketingLinesFormat((List)AirProductHelper.getAirProductsList((Reservation)reservation));
        }
        HashSet<BigInteger> result = new HashSet<BigInteger>();
        for (ETicketNumberType ticket : response.getReservation().getReservationChoiceGroup().getPassengerReservation().getTicketingInfo().getETicketNumberList()) {
            String ticketNumber;
            if (TextUtil.isBlank((String)ticket.getString()) || !ticket.getString().startsWith("TE") && !ticket.getString().startsWith("ME") || !ticketNumbers.contains(ticketNumber = ticket.getString().substring(3, 16))) continue;
            result.add(ticket.getIndex());
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.RPHS_TO_VOID, result);
    }
}

