/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.wpdf;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.AirPriceRQParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.wpdf.WPDFHelper;
import com.gridnine.xtrip.server.gds.sabre.wpdf.WPDFStructuredResponse;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class UpdateProductsFromWPDFProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirPriceRQParameters parameters = (AirPriceRQParameters)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.AIR_PRICE_RQ_PARAMETERS);
        WPDFStructuredResponse response = (WPDFStructuredResponse)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.WPDF_RESPONSE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product prod : GDSHelper.getProducts((Reservation)reservation)) {
            if (!parameters.getNameNumbers().contains(prod.getGdsId())) continue;
            String passengerTypeCode = SabreHelper.getNativeCode((DictionaryReference)prod.getPassengerType());
            WPDFStructuredResponse.PQ pq = WPDFHelper.getPq(passengerTypeCode, response);
            for (Tax tax : prod.getTaxes()) {
                List<WPDFStructuredResponse.PQ.TaxDetails> tds = WPDFHelper.getTaxDetails(tax.getCode(), pq);
                Money m = new Money();
                m.setCurrency(WPDFHelper.getTaxBaseCurrencyCode(tds));
                m.setValue(WPDFHelper.getTaxBaseAmount(tds));
                tax.setAmount(m);
            }
        }
    }
}

