/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.wpdf;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.sabre.wpdf.WPDFStructuredResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

public class WPDFHelper {
    public static WPDFStructuredResponse.PQ getPq(String passengerTypeCode, WPDFStructuredResponse response) {
        for (WPDFStructuredResponse.PQ pq : response.getPqs()) {
            if (!pq.getPassengerTypeCode().equals(passengerTypeCode)) continue;
            return pq;
        }
        throw Xeption.forDeveloper((String)"pq not found for passenger type {0}", (Object[])new Object[]{passengerTypeCode});
    }

    public static List<WPDFStructuredResponse.PQ.TaxDetails> getTaxDetails(String code, WPDFStructuredResponse.PQ pq) {
        String pattern = "/".concat(code);
        return pq.getTaxDetails().stream().filter(td -> td.getCodes().contains(pattern)).collect(Collectors.toList());
    }

    public static String getTaxBaseCurrencyCode(List<WPDFStructuredResponse.PQ.TaxDetails> taxDetailsList) {
        return taxDetailsList.get(0).getTaxBreakdowns().get(0).getBaseCurrencyCode();
    }

    public static BigDecimal getTaxBaseAmount(List<WPDFStructuredResponse.PQ.TaxDetails> taxDetailsList) {
        return taxDetailsList.stream().flatMap(td -> td.getTaxBreakdowns().stream()).map(WPDFStructuredResponse.PQ.TaxDetails.TaxBreakdown::getBaseAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

